/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.configs;

import com.shanebeestudios.hg.api.parsers.LocationParser;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.api.util.Vault;
import com.shanebeestudios.hg.plugin.HungerGames;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    public static boolean SETTINGS_DEBUG;
    public static boolean SETTINGS_BROADCAST_JOIN_MESSAGES;
    public static boolean SETTINGS_BROADCAST_WIN_MESSAGES;
    public static boolean HAS_ECONOMY;
    public static boolean SETTINGS_BOSSBAR_COUNTDOWN;
    public static int SETTINGS_TRACKING_STICK_USES;
    public static int SETTINGS_PLAYERS_FOR_TRACKING_STICK;
    public static int SETTINGS_TELEPORT_AT_END_TIME;
    public static boolean SETTINGS_SAVE_PREVIOUS_LOCATION;
    public static int SETTINGS_FREE_ROAM_TIME;
    public static Location SETTINGS_GLOBAL_EXIT_LOCATION;
    public static boolean SCOREBOARD_HIDE_NAMETAGS;
    public static boolean SCOREBOARD_SHOW_HEALTH_ENABLED;
    public static String SCOREBOARD_SHOW_HEALTH_DISPLAY_SLOT;
    public static String SCOREBOARD_SHOW_HEALTH_RENDER_TYPE;
    public static boolean TEAM_SHOW_TEAM_NAMES;
    public static int TEAM_MAX_TEAM_SIZE;
    public static boolean TEAM_ALLOW_FRIENDLY_FIRE;
    public static boolean TEAM_CAN_SEE_INVISIBLES;
    public static boolean MOBS_SPAWN_ENABLED;
    public static int MOBS_SPAWN_INTERVAL;
    public static int MOBS_SPAWN_CAP_PER_PLAYER;
    public static boolean REWARD_ENABLED;
    public static int REWARD_CASH;
    public static List<String> REWARD_COMMANDS;
    public static List<String> REWARD_MESSAGES;
    public static boolean ROLLBACK_ALLOW_BREAK_BLOCKS;
    public static int ROLLBACK_BLOCKS_PER_SECOND;
    public static boolean ROLLBACK_PROTECT_DURING_FREE_ROAM;
    public static boolean ROLLBACK_PREVENT_TRAMPLING;
    public static List<String> ROLLBACK_EDITABLE_BLOCKS;
    public static boolean ROLLBACK_ALLOW_ITEMFRAME_TAKE;
    public static int CHESTS_REGULAR_MIN_CONTENT;
    public static int CHESTS_REGULAR_MAX_CONTENT;
    public static int CHESTS_BONUS_MIN_CONTENT;
    public static int CHESTS_BONUS_MAX_CONTENT;
    public static List<String> CHESTS_BONUS_BLOCK_TYPES;
    public static boolean CHESTS_BONUS_RANDOMIZE_ENABLED;
    public static int CHESTS_BONUS_RANDOMIZE_MIN;
    public static int CHESTS_BONUS_RANDOMIZE_MAX;
    public static String CHESTS_BONUS_RANDOMIZE_BLOCK;
    public static boolean CHESTS_CHEST_DROP_ENABLED;
    public static int CHESTS_CHEST_DROP_INTERVAL;
    public static int CHESTS_CHEST_DROP_MIN_CONTENT;
    public static int CHESTS_CHEST_DROP_MAX_CONTENT;
    public static boolean WORLD_BORDER_ENABLED;
    public static boolean WORLD_BORDER_INITIATE_ON_START;
    public static String WORLD_BORDER_CENTER;
    public static int WORLD_BORDER_COUNTDOWN_START;
    public static int WORLD_BORDER_COUNTDOWN_END;
    public static int WORLD_BORDER_FINAL_SIZE;
    public static boolean SPECTATE_ENABLED;
    public static boolean SPECTATE_DEATH_TO_SPECTATE;
    public static boolean SPECTATE_HIDE_HIDE_SPECTATORS;
    public static boolean SPECTATE_FLY;
    public static boolean SPECTATE_CHAT;
    public static String SOUNDS_DEATH;
    public static String SOUNDS_OPEN_CHEST_DROP;
    public static List<String> COMMANDS_ALLOWED_IN_GAME;
    private final HungerGames plugin;
    private File configFile;
    private FileConfiguration config;

    public Config(HungerGames plugin) {
        this.plugin = plugin;
        this.loadConfigFile();
    }

    private void loadConfigFile() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
            Util.log("New config.yml <green>created", new Object[0]);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.matchConfig(this.config, this.configFile);
        this.loadConfig();
        Util.log("config.yml <green>successfully loaded", new Object[0]);
    }

    private void loadConfig() {
        SETTINGS_DEBUG = this.config.getBoolean("settings.debug");
        SETTINGS_BROADCAST_JOIN_MESSAGES = this.config.getBoolean("settings.broadcast-join-messages");
        SETTINGS_BROADCAST_WIN_MESSAGES = this.config.getBoolean("settings.broadcast-win-messages");
        SETTINGS_BOSSBAR_COUNTDOWN = this.config.getBoolean("settings.bossbar-countdown");
        SETTINGS_TRACKING_STICK_USES = this.config.getInt("settings.tracking-stick-uses");
        SETTINGS_PLAYERS_FOR_TRACKING_STICK = this.config.getInt("settings.players-for-tracking-stick");
        SETTINGS_SAVE_PREVIOUS_LOCATION = this.config.getBoolean("settings.save-previous-location");
        SETTINGS_TELEPORT_AT_END_TIME = this.config.getInt("settings.teleport-at-end-time");
        SETTINGS_FREE_ROAM_TIME = this.config.getInt("settings.free-room-time");
        String locString = this.config.getString("settings.global-exit-location");
        if (locString != null && locString.contains(":")) {
            SETTINGS_GLOBAL_EXIT_LOCATION = LocationParser.getLocFromString(locString);
        }
        SCOREBOARD_HIDE_NAMETAGS = this.config.getBoolean("scoreboard.hide-nametags");
        SCOREBOARD_SHOW_HEALTH_ENABLED = this.config.getBoolean("scoreboard.show-health.enabled");
        SCOREBOARD_SHOW_HEALTH_DISPLAY_SLOT = this.config.getString("scoreboard.show-health.display-slot");
        SCOREBOARD_SHOW_HEALTH_RENDER_TYPE = this.config.getString("scoreboard.show-health.render-type");
        TEAM_MAX_TEAM_SIZE = this.config.getInt("scoreboard.teams.max-team-size");
        TEAM_SHOW_TEAM_NAMES = this.config.getBoolean("scoreboard.teams.show-team-nametags");
        TEAM_ALLOW_FRIENDLY_FIRE = this.config.getBoolean("scoreboard.teams.allow-friendly-fire");
        TEAM_CAN_SEE_INVISIBLES = this.config.getBoolean("scoreboard.teams.can-see-friendly-invisibles");
        MOBS_SPAWN_ENABLED = this.config.getBoolean("mob-spawning.enabled");
        MOBS_SPAWN_INTERVAL = this.config.getInt("mob-spawning.interval") * 20;
        MOBS_SPAWN_CAP_PER_PLAYER = this.config.getInt("mob-spawning.cap-per-player");
        REWARD_ENABLED = this.config.getBoolean("reward.enabled");
        REWARD_CASH = this.config.getInt("reward.cash");
        REWARD_COMMANDS = this.config.getStringList("reward.commands");
        REWARD_MESSAGES = this.config.getStringList("reward.messages");
        ROLLBACK_ALLOW_BREAK_BLOCKS = this.config.getBoolean("rollback.allow-block-break");
        ROLLBACK_BLOCKS_PER_SECOND = this.config.getInt("rollback.blocks-per-second");
        ROLLBACK_PROTECT_DURING_FREE_ROAM = this.config.getBoolean("rollback.protect-during-free-roam");
        ROLLBACK_PREVENT_TRAMPLING = this.config.getBoolean("rollback.prevent-trampling");
        ROLLBACK_EDITABLE_BLOCKS = this.config.getStringList("rollback.editable-blocks");
        ROLLBACK_ALLOW_ITEMFRAME_TAKE = this.config.getBoolean("rollback.allow-itemframe-take");
        CHESTS_REGULAR_MIN_CONTENT = this.config.getInt("chests.regular.min-content");
        CHESTS_REGULAR_MAX_CONTENT = this.config.getInt("chests.regular.max-content");
        CHESTS_BONUS_MIN_CONTENT = this.config.getInt("chests.bonus.min-content");
        CHESTS_BONUS_MAX_CONTENT = this.config.getInt("chests.bonus.max-content");
        CHESTS_BONUS_BLOCK_TYPES = this.config.getStringList("chests.bonus.block-types");
        CHESTS_BONUS_RANDOMIZE_ENABLED = this.config.getBoolean("chests.bonus.randomize.enabled");
        CHESTS_BONUS_RANDOMIZE_MIN = this.config.getInt("chests.bonus.randomize.min");
        CHESTS_BONUS_RANDOMIZE_MAX = this.config.getInt("chests.bonus.randomize.max");
        CHESTS_BONUS_RANDOMIZE_BLOCK = this.config.getString("chests.bonus.randomize.block");
        CHESTS_CHEST_DROP_ENABLED = this.config.getBoolean("chests.chest-drop.enabled");
        CHESTS_CHEST_DROP_INTERVAL = this.config.getInt("chests.chest-drop.interval");
        CHESTS_CHEST_DROP_MIN_CONTENT = this.config.getInt("chests.chest-drop.min-content");
        CHESTS_CHEST_DROP_MAX_CONTENT = this.config.getInt("chests.chest-drop.max-content");
        WORLD_BORDER_ENABLED = this.config.getBoolean("world-border.enabled");
        WORLD_BORDER_INITIATE_ON_START = this.config.getBoolean("world-border.initiate-on-start");
        WORLD_BORDER_CENTER = this.config.getString("world-border.center");
        WORLD_BORDER_COUNTDOWN_START = this.config.getInt("world-border.countdown-start");
        WORLD_BORDER_COUNTDOWN_END = this.config.getInt("world-border.countdown-end");
        WORLD_BORDER_FINAL_SIZE = this.config.getInt("world-border.final-border-size");
        SPECTATE_ENABLED = this.config.getBoolean("spectate.enabled");
        SPECTATE_DEATH_TO_SPECTATE = this.config.getBoolean("spectate.death-to-spectate");
        SPECTATE_HIDE_HIDE_SPECTATORS = this.config.getBoolean("spectate.hide-spectators");
        SPECTATE_FLY = this.config.getBoolean("spectate.fly");
        SPECTATE_CHAT = this.config.getBoolean("spectate.chat");
        SOUNDS_DEATH = this.config.getString("sounds.death");
        SOUNDS_OPEN_CHEST_DROP = this.config.getString("sounds.open-chest-drop");
        COMMANDS_ALLOWED_IN_GAME = this.config.getStringList("commands.allowed-in-game");
        try {
            Vault.setupEconomy();
            if (Vault.ECONOMY == null) {
                Util.log("<red>Unable to setup vault!", new Object[0]);
                Util.log(" - <red>Economy provider is missing.", new Object[0]);
                Util.log(" - <yellow>Cash rewards will not be given out..", new Object[0]);
                REWARD_ENABLED = false;
                HAS_ECONOMY = false;
            }
        }
        catch (NoClassDefFoundError e) {
            Util.log("<red>Unable to setup vault!", new Object[0]);
            Util.log("  - <yellow>Cash rewards will not be given out..", new Object[0]);
            REWARD_ENABLED = false;
            HAS_ECONOMY = false;
        }
    }

    private void matchConfig(FileConfiguration config, File file) {
        try {
            boolean hasUpdated = false;
            InputStream test = this.plugin.getResource(file.getName());
            assert (test != null);
            InputStreamReader is = new InputStreamReader(test);
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)is);
            for (String key : defConfig.getConfigurationSection("").getKeys(true)) {
                if (config.contains(key) || key.contains("kits")) continue;
                config.set(key, defConfig.get(key));
                hasUpdated = true;
            }
            for (String key : config.getConfigurationSection("").getKeys(true)) {
                if (defConfig.contains(key) || key.contains("kits.")) continue;
                config.set(key, null);
                hasUpdated = true;
            }
            if (hasUpdated) {
                config.save(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setGlobalExitLocation(Location location) {
        String locString = LocationParser.locToString(location);
        this.config.set("settings.global-exit-location", (Object)locString);
        this.save();
    }

    static {
        HAS_ECONOMY = true;
    }
}

