/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Constants;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.listeners.GameListenerBase;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GameLobbyListener
extends GameListenerBase {
    public GameLobbyListener(HungerGames plugin) {
        super(plugin);
    }

    @EventHandler
    private void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        assert (block != null);
        if (!Tag.ALL_SIGNS.isTagged((Keyed)block.getType())) {
            return;
        }
        Sign sign = (Sign)block.getState();
        PersistentDataContainer pdc = sign.getPersistentDataContainer();
        if (pdc.has(Constants.LOBBY_SIGN_KEY, PersistentDataType.STRING)) {
            String name = (String)pdc.get(Constants.LOBBY_SIGN_KEY, PersistentDataType.STRING);
            Game game = this.gameManager.getGame(name);
            if (game == null) {
                Util.sendMessage((CommandSender)player, this.lang.command_delete_no_exist, new Object[0]);
            } else if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> game.joinGame(player), 2L);
            } else {
                Util.sendMessage((CommandSender)player, this.lang.listener_sign_click_hand, new Object[0]);
            }
        }
    }
}

