/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.ItemUtils;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.listeners.GameListenerBase;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class GameTrackingStickListener
extends GameListenerBase {
    public GameTrackingStickListener(HungerGames plugin) {
        super(plugin);
    }

    @EventHandler
    private void onClickWithStick(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            ItemStack item = event.getItem();
            if (this.playerManager.hasPlayerData(player) && ItemUtils.isTrackingStick(item)) {
                event.setCancelled(true);
                this.useTrackStick(player, item);
            }
        }
    }

    private void useTrackStick(Player player, ItemStack itemStack) {
        PlayerData playerData = this.playerManager.getPlayerData(player);
        assert (playerData != null);
        Game game = playerData.getGame();
        BoundingBox box = game.getGameArenaData().getGameRegion().getBoundingBox();
        int distance = (int)Math.min(120.0, Math.max(box.getWidthX() / 2.0, box.getWidthZ() / 2.0));
        for (Entity nearbyEntity : player.getNearbyEntities((double)distance, 50.0, (double)distance)) {
            if (!(nearbyEntity instanceof Player)) continue;
            Player nearbyPlayer = (Player)nearbyEntity;
            if (!game.getGamePlayerData().getPlayers().contains(nearbyPlayer)) continue;
            Location location = nearbyEntity.getLocation();
            int range = (int)player.getLocation().distance(location);
            Util.sendMessage((CommandSender)player, this.lang.item_tracking_stick_nearest.replace("<player>", nearbyEntity.getName()).replace("<range>", "" + range).replace("<location>", this.getDirection(player.getLocation().getBlock(), location.getBlock())), new Object[0]);
            itemStack.damage(1, (LivingEntity)player);
            player.updateInventory();
            return;
        }
        Util.sendMessage((CommandSender)player, this.lang.item_tracking_stick_no_near, new Object[0]);
    }

    private String getDirection(Block block, Block block1) {
        Vector bv = block.getLocation().toVector();
        Vector bv2 = block1.getLocation().toVector();
        float y = (float)this.angle(bv.getX(), bv.getZ(), bv2.getX(), bv2.getZ());
        float cal = y * 10.0f;
        int c = (int)cal;
        if (c <= 1 && c >= -1) {
            return "South";
        }
        if (c > -14 && c < -1) {
            return "SouthWest";
        }
        if (c >= -17 && c <= -14) {
            return "West";
        }
        if (c > -29 && c < -17) {
            return "NorthWest";
        }
        if (c > 17 && c < 29) {
            return "NorthEast";
        }
        if (c <= 17 && c >= 14) {
            return "East";
        }
        if (c > 1 && c < 14) {
            return "SouthEast";
        }
        if (c <= 29 && c >= -29) {
            return "North";
        }
        return "UnKnown";
    }

    private double angle(double d, double e, double f, double g) {
        int x = (int)(f - d);
        int z = (int)(g - e);
        return Math.atan2(x, z);
    }
}

