/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.data.PlayerSession;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import com.shanebeestudios.hg.plugin.managers.SessionManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;

public class SessionWandListener
implements Listener {
    private final SessionManager sessionManager;
    private final GameManager gameManager;
    private final Language lang;

    public SessionWandListener(HungerGames plugin) {
        this.sessionManager = plugin.getSessionManager();
        this.gameManager = plugin.getGameManager();
        this.lang = plugin.getLang();
    }

    @EventHandler
    private void onSelection(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Action action = event.getAction();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = block.getLocation();
        if (!player.getInventory().getItemInMainHand().getType().equals((Object)Material.STICK)) {
            return;
        }
        PlayerSession session = this.sessionManager.getPlayerSession(player);
        if (session != null && (action.equals((Object)Action.RIGHT_CLICK_BLOCK) || action.equals((Object)Action.LEFT_CLICK_BLOCK))) {
            if (event.getHand() == EquipmentSlot.OFF_HAND) {
                return;
            }
            event.setCancelled(true);
            for (Game game : this.gameManager.getGames()) {
                if (!game.getGameArenaData().getGameRegion().isInRegion(location)) continue;
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_already_in_arena, new Object[0]);
                return;
            }
            session.click(player, block);
        }
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.sessionManager.endPlayerSession(player);
    }
}

