/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.managers;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.status.PlayerStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlayerManager {
    private final Map<UUID, PlayerData> playerMap = new HashMap<UUID, PlayerData>();
    private final Map<UUID, PlayerData> spectatorMap = new HashMap<UUID, PlayerData>();

    public boolean hasPlayerData(Player player) {
        return this.playerMap.containsKey(player.getUniqueId());
    }

    public boolean hasSpectatorData(Player player) {
        return this.spectatorMap.containsKey(player.getUniqueId());
    }

    @Nullable
    public PlayerData getPlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.playerMap.containsKey(uuid)) {
            return this.playerMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public PlayerData getSpectatorData(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.spectatorMap.containsKey(uuid)) {
            return this.spectatorMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public PlayerData getData(Player player) {
        if (this.hasPlayerData(player)) {
            return this.getPlayerData(player);
        }
        if (this.hasSpectatorData(player)) {
            return this.getSpectatorData(player);
        }
        return null;
    }

    public void createPlayerData(Player player, Game game) {
        PlayerData playerData = new PlayerData(player, game);
        this.playerMap.put(player.getUniqueId(), playerData);
    }

    public void createSpectatorData(Player spectator, Game game) {
        PlayerData playerData = new PlayerData(spectator, game);
        this.spectatorMap.put(spectator.getUniqueId(), playerData);
    }

    public void removePlayerData(Player player) {
        this.playerMap.remove(player.getUniqueId());
    }

    public void removePlayerData(UUID uuid) {
        this.playerMap.remove(uuid);
    }

    public void removeSpectatorData(Player player) {
        this.spectatorMap.remove(player.getUniqueId());
    }

    public void removeSpectatorData(UUID uuid) {
        this.spectatorMap.remove(uuid);
    }

    public void transferPlayerDataToSpectator(Player player) {
        PlayerData clone;
        UUID uuid = player.getUniqueId();
        if (this.playerMap.containsKey(uuid) && (clone = this.playerMap.get(uuid).clone()) != null) {
            this.spectatorMap.put(uuid, clone);
            this.playerMap.remove(uuid);
        }
    }

    @Nullable
    public Game getGame(Player player) {
        if (this.hasPlayerData(player)) {
            return this.getPlayerData(player).getGame();
        }
        if (this.hasSpectatorData(player)) {
            return this.getSpectatorData(player).getGame();
        }
        return null;
    }

    public boolean isInGame(Player player) {
        return this.getPlayerStatus(player) != PlayerStatus.NOT_IN_GAME;
    }

    public PlayerStatus getPlayerStatus(Player player) {
        if (this.hasPlayerData(player)) {
            return PlayerStatus.IN_GAME;
        }
        if (this.hasSpectatorData(player)) {
            return PlayerStatus.SPECTATOR;
        }
        return PlayerStatus.NOT_IN_GAME;
    }
}

