/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.tasks;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FreeRoamTask
implements Runnable {
    private final Game game;
    private final Language lang;
    private final int roamTime;
    private final int taskId;

    public FreeRoamTask(Game game) {
        this.game = game;
        this.lang = game.getPlugin().getLang();
        int roamTime = game.getGameArenaData().getFreeRoamTime();
        if (roamTime < 0) {
            roamTime = Config.SETTINGS_FREE_ROAM_TIME;
        }
        this.roamTime = Math.max(roamTime, 0);
        String gameStarted = this.lang.game_roam_game_started;
        String roamTimeString = this.lang.game_roam_time.replace("<roam>", "" + this.roamTime);
        for (Player player : game.getGamePlayerData().getPlayers()) {
            Util.sendMessage((CommandSender)player, gameStarted, new Object[0]);
            if (this.roamTime > 0) {
                Util.sendMessage((CommandSender)player, roamTimeString, new Object[0]);
            }
            player.setHealth(20.0);
            player.setFoodLevel(20);
            game.getGamePlayerData().unFreeze(player);
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)HungerGames.getPlugin(), (Runnable)this, (long)this.roamTime * 20L);
    }

    @Override
    public void run() {
        if (this.roamTime > 0) {
            this.game.getGamePlayerData().messageAllActivePlayers(this.lang.game_roam_finished);
        }
        this.game.startRunningGame();
    }

    public void stop() {
        Bukkit.getScheduler().cancelTask(this.taskId);
    }
}

