/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.tasks;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameEntityData;
import com.shanebeestudios.hg.api.game.GamePlayerData;
import com.shanebeestudios.hg.plugin.configs.Config;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class MobSpawnerTask
implements Runnable {
    private final GamePlayerData gamePlayerData;
    private final GameArenaData gameArenaData;
    private final GameEntityData gameEntityData;
    private final int taskId;
    private final Random random = new Random();
    private final World world;
    private final int cap = Config.MOBS_SPAWN_CAP_PER_PLAYER;

    public MobSpawnerTask(Game game) {
        this.gamePlayerData = game.getGamePlayerData();
        this.gameArenaData = game.getGameArenaData();
        this.gameEntityData = game.getGameEntityData();
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)game.getGameArenaData().getPlugin(), (Runnable)this, (long)Config.MOBS_SPAWN_INTERVAL, (long)Config.MOBS_SPAWN_INTERVAL);
        this.world = game.getGameArenaData().getGameRegion().getWorld();
    }

    @Override
    public void run() {
        int playerCap;
        int entityCount = this.gameEntityData.getLoggedEntityCount();
        if (entityCount > (playerCap = this.gamePlayerData.getPlayers().size() * this.cap)) {
            return;
        }
        for (Player player : this.gamePlayerData.getPlayers()) {
            if (entityCount > playerCap) {
                return;
            }
            Location spawnLocation = this.getSafeSpawnLocation(this.world, player.getLocation().clone());
            if (spawnLocation == null || !this.gameArenaData.isInRegion(spawnLocation) || !this.gameEntityData.spawnMob(spawnLocation, this.isDayTime())) continue;
            ++entityCount;
        }
    }

    private boolean isDayTime() {
        long time = this.world.getTime();
        return time < 12542L || time > 23460L;
    }

    private int getRandomNumber() {
        int randomInt = this.random.nextInt(20) + 6;
        return this.random.nextBoolean() ? randomInt : -randomInt;
    }

    @Nullable
    private Location getSafeSpawnLocation(World world, Location location) {
        int x = location.getBlockX() + this.getRandomNumber();
        int y = location.getBlockY();
        int z = location.getBlockZ() + this.getRandomNumber();
        for (int trys = 30; trys > 0; --trys) {
            Material material = world.getBlockAt(x, y, z).getType();
            Material below = world.getBlockAt(x, y - 1, z).getType();
            Material above = world.getBlockAt(x, y + 1, z).getType();
            if (material.isSolid()) {
                ++y;
                continue;
            }
            if (below == Material.AIR) {
                --y;
                continue;
            }
            if (below == Material.WATER || below == Material.LAVA || above.isSolid()) {
                x += this.getRandomNumber();
                z += this.getRandomNumber();
                continue;
            }
            return new Location(world, (double)x, (double)y, (double)z);
        }
        return null;
    }

    public void stop() {
        Bukkit.getScheduler().cancelTask(this.taskId);
    }
}

