/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.tasks;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class NearestPlayerCompassTask
implements Runnable {
    private final Game game;
    private final Language lang;
    private final PlayerManager playerManager;
    private final int taskId;

    public NearestPlayerCompassTask(Game game) {
        this.game = game;
        this.lang = game.getPlugin().getLang();
        this.playerManager = game.getPlugin().getPlayerManager();
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)HungerGames.getPlugin(), (Runnable)this, 10L, 10L);
    }

    @Override
    public void run() {
        for (Player player : this.game.getGamePlayerData().getPlayers()) {
            Player nearest;
            PlayerData playerData;
            if (player.getInventory().getItemInMainHand().getType() != Material.COMPASS || (playerData = this.playerManager.getPlayerData(player)) == null || (nearest = this.getNearestPlayer(player)) == null) continue;
            String info = this.lang.item_compass_nearest_player.replace("<player>", nearest.getName()).replace("<distance>", String.format("%.2f", nearest.getLocation().distance(player.getLocation())));
            player.sendActionBar(Util.getMini(info, new Object[0]));
            player.setCompassTarget(nearest.getLocation());
        }
    }

    @Nullable
    private Player getNearestPlayer(Player player) {
        double distance = 20000.0;
        Player nearest = null;
        for (Player potential : this.game.getGamePlayerData().getPlayers()) {
            double d;
            if (potential == player || !((d = player.getLocation().distanceSquared(potential.getLocation())) < distance)) continue;
            distance = d;
            nearest = potential;
        }
        return nearest;
    }

    public void stop() {
        Bukkit.getScheduler().cancelTask(this.taskId);
    }
}

