/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.shaded-api.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.CommandAPIArgumentType;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.SafeOverrideableArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.exceptions.InvalidRangeException;
import com.shanebeestudios.hg.shaded-api.commandapi.executors.CommandArguments;

public class FloatArgument
extends SafeOverrideableArgument<Float, Float> {
    public FloatArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg(), String::valueOf);
    }

    public FloatArgument(String nodeName, float min) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min), String::valueOf);
    }

    public FloatArgument(String nodeName, float min, float max) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min, (float)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Float> getPrimitiveType() {
        return Float.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_FLOAT;
    }

    @Override
    public <Source> Float parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Float)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

