/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.shaded-api.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.CommandAPIArgumentType;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.SafeOverrideableArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.exceptions.InvalidRangeException;
import com.shanebeestudios.hg.shaded-api.commandapi.executors.CommandArguments;

public class LongArgument
extends SafeOverrideableArgument<Long, Long> {
    public LongArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg(), String::valueOf);
    }

    public LongArgument(String nodeName, long min) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min), String::valueOf);
    }

    public LongArgument(String nodeName, long min, long max) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min, (long)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Long> getPrimitiveType() {
        return Long.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_LONG;
    }

    @Override
    public <Source> Long parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Long)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

