/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.shaded-api.fastboard;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.Bukkit;

public final class FastReflection {
    private static final String NM_PACKAGE = "net.minecraft";
    private static final String OBC_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    private static final String NMS_PACKAGE = OBC_PACKAGE.replace("org.bukkit.craftbukkit", "net.minecraft.server");
    private static final MethodType VOID_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final boolean NMS_REPACKAGED = FastReflection.optionalClass("net.minecraft.network.protocol.Packet").isPresent();
    private static final boolean MOJANG_MAPPINGS = FastReflection.optionalClass("net.minecraft.network.chat.Component").isPresent();
    private static volatile Object theUnsafe;

    private FastReflection() {
        throw new UnsupportedOperationException();
    }

    public static boolean isRepackaged() {
        return NMS_REPACKAGED;
    }

    public static String nmsClassName(String post1_17package, String className) {
        if (NMS_REPACKAGED) {
            String classPackage = post1_17package == null ? NM_PACKAGE : "net.minecraft." + post1_17package;
            return classPackage + '.' + className;
        }
        return NMS_PACKAGE + '.' + className;
    }

    public static Class<?> nmsClass(String post1_17package, String className) throws ClassNotFoundException {
        return Class.forName(FastReflection.nmsClassName(post1_17package, className));
    }

    public static Class<?> nmsClass(String post1_17package, String spigotClass, String mojangClass) throws ClassNotFoundException {
        return FastReflection.nmsClass(post1_17package, MOJANG_MAPPINGS ? mojangClass : spigotClass);
    }

    public static Optional<Class<?>> nmsOptionalClass(String post1_17package, String className) {
        return FastReflection.optionalClass(FastReflection.nmsClassName(post1_17package, className));
    }

    public static String obcClassName(String className) {
        return OBC_PACKAGE + '.' + className;
    }

    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(FastReflection.obcClassName(className));
    }

    public static Optional<Class<?>> obcOptionalClass(String className) {
        return FastReflection.optionalClass(FastReflection.obcClassName(className));
    }

    public static Optional<Class<?>> optionalClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static Object enumValueOf(Class<?> enumClass, String enumName) {
        return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
    }

    public static Object enumValueOf(Class<?> enumClass, String enumName, int fallbackOrdinal) {
        try {
            return FastReflection.enumValueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] constants = enumClass.getEnumConstants();
            if (constants.length > fallbackOrdinal) {
                return constants[fallbackOrdinal];
            }
            throw e;
        }
    }

    static Class<?> innerClass(Class<?> parentClass, Predicate<Class<?>> classPredicate) throws ClassNotFoundException {
        for (Class<?> innerClass : parentClass.getDeclaredClasses()) {
            if (!classPredicate.test(innerClass)) continue;
            return innerClass;
        }
        throw new ClassNotFoundException("No class in " + parentClass.getCanonicalName() + " matches the predicate.");
    }

    static Optional<MethodHandle> optionalConstructor(Class<?> declaringClass, MethodHandles.Lookup lookup, MethodType type) throws IllegalAccessException {
        try {
            return Optional.of(lookup.findConstructor(declaringClass, type));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PacketConstructor findPacketConstructor(Class<?> packetClass, MethodHandles.Lookup lookup) throws Exception {
        try {
            MethodHandle constructor2 = lookup.findConstructor(packetClass, VOID_METHOD_TYPE);
            return (PacketConstructor)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invoke(), ()Ljava/lang/Object;)((MethodHandle)constructor2);
        }
        catch (IllegalAccessException | NoSuchMethodException constructor2) {
            if (theUnsafe == null) {
                Class<FastReflection> constructor2 = FastReflection.class;
                // MONITORENTER : com.shanebeestudios.hg.shaded-api.fastboard.FastReflection.class
                if (theUnsafe == null) {
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    theUnsafeField.setAccessible(true);
                    theUnsafe = theUnsafeField.get(null);
                }
                // MONITOREXIT : constructor2
            }
            MethodType allocateMethodType = MethodType.methodType(Object.class, Class.class);
            MethodHandle allocateMethod = lookup.findVirtual(theUnsafe.getClass(), "allocateInstance", allocateMethodType);
            return () -> allocateMethod.invoke(theUnsafe, packetClass);
        }
    }

    @FunctionalInterface
    static interface PacketConstructor {
        public Object invoke() throws Throwable;
    }
}

