/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.mojang.brigadier.CommandDispatcher;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Constants;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.command.ICommand;
import dev.lumentae.lattice.dispenser.DispenserBehavior;
import dev.lumentae.lattice.packet.ClientboundRulesPacket;
import dev.lumentae.lattice.packet.ServerboundAcceptedRulesPacket;
import dev.lumentae.lattice.packet.ServerboundModSharePacket;
import dev.lumentae.lattice.platform.Services;
import dev.lumentae.lattice.util.PacketUtils;
import dev.lumentae.lattice.util.Utils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_8828;
import net.minecraft.server.MinecraftServer;

public class Event {
    public static void OnServerStarted(MinecraftServer server) {
        Mod.setServer(server);
        class_3222 player = Services.PLATFORM.getFakePlayer(server);
        class_2357 behaviors = DispenserBehavior.getDispenserBehavior(player);
        class_7923.field_41178.forEach(item -> {
            if (class_2315.field_10919.containsKey(item)) {
                return;
            }
            class_2315.method_10009((class_1935)item, (class_2357)behaviors);
        });
    }

    public static void OnServerStopping(MinecraftServer server) {
        Mod.setServer(null);
        Config.saveConfig();
    }

    public static void OnRespawn(class_3222 player) {
        if (player.method_43122().isEmpty()) {
            return;
        }
        class_4208 o = (class_4208)player.method_43122().get();
        player.method_64398((class_2561)class_2561.method_43471((String)"message.lattice.death.1").method_27693(String.valueOf(o.comp_2208().method_10263())).method_27693(", ").method_27693(String.valueOf(o.comp_2208().method_10264())).method_27693(", ").method_27693(String.valueOf(o.comp_2208().method_10260())).method_10852((class_2561)class_2561.method_43471((String)"message.lattice.death.2")));
    }

    public static void OnJoin(class_3244 handler) {
        class_3222 player = handler.method_32311();
        if (player.method_51469().method_8608()) {
            return;
        }
        Config.INSTANCE.playerOptions.computeIfAbsent(player.method_5667(), k -> Config.DEFAULT_PLAY_OPTIONS);
        if (Config.INSTANCE.serverOpenDate.isAfter(LocalDateTime.now()) && !player.method_64475(2)) {
            class_5250 reason = class_2561.method_43471((String)"message.lattice.server.closed.1").method_10852((class_2561)class_2561.method_43471((String)"message.lattice.server.closed.2")).method_10852((class_2561)class_5250.method_43477((class_7417)new class_8828.class_2585(Config.INSTANCE.serverOpenDate.toString())).method_27694(style -> style.method_10977(class_124.field_1060))).method_27693("!");
            class_2661 packet = new class_2661((class_2561)reason);
            handler.method_14364((class_2596)packet);
        }
        if (!Config.INSTANCE.rules.isEmpty() && !Config.getPlayerPlayOptions((UUID)player.method_5667()).acceptedRules) {
            PacketUtils.sendToClient(player, ClientboundRulesPacket.create());
        }
    }

    public static void OnCommandRegister(CommandDispatcher<class_2168> dispatcher) {
        for (ICommand command : Constants.COMMANDS) {
            command.register(dispatcher);
        }
    }

    public static void OnModSharePacket(ServerboundModSharePacket packet) {
        Constants.LOG.info("Received mod/resource pack list from server:");
        Constants.LOG.info("Origin: {} ({})", (Object)packet.origin(), (Object)Utils.getPlayerNameByUUID(UUID.fromString(packet.origin())));
        Constants.LOG.info("Mods: {}", (Object)packet.mods());
        Constants.LOG.info("Resource Packs: {}", (Object)packet.resourcePacks());
        if (Utils.containsIllegalMods(packet.mods()) || Utils.containsIllegalMods(packet.resourcePacks())) {
            Constants.LOG.warn("Illegal mods or resource packs!");
            ArrayList<String> illegalMods = new ArrayList<String>(packet.mods().lines().filter(Utils::containsIllegalMods).toList());
            illegalMods.addAll(packet.resourcePacks().lines().filter(Utils::containsIllegalMods).toList());
            class_3222 player = Utils.getPlayerByUUID(UUID.fromString(packet.origin()));
            if (player == null) {
                return;
            }
            class_5250 reason = class_2561.method_43471((String)"message.lattice.illegal_mods").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"\n- ")).method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)"\n- ", illegalMods)).method_27692(class_124.field_1061));
            player.field_13987.method_52396((class_2561)reason);
        }
    }

    public static void OnShareMods(class_1657 player) {
        PacketUtils.sendToServer(ServerboundModSharePacket.create(player));
    }

    public static void OnAcceptedRulesPacket(ServerboundAcceptedRulesPacket data, class_3222 player) {
        if (!data.accepted()) {
            class_5250 reason = class_2561.method_43471((String)"message.lattice.rules.not_accepted").method_27692(class_124.field_1061);
            player.field_13987.method_52396((class_2561)reason);
            return;
        }
        Config.getPlayerPlayOptions((UUID)player.method_5667()).acceptedRules = true;
        Config.saveConfig();
    }
}

