/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.command.ICommand;
import dev.lumentae.lattice.nickname.NicknameManager;
import dev.lumentae.lattice.status.StatusManager;
import dev.lumentae.lattice.util.TextUtils;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;

public class LatticeCommand
implements ICommand {
    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lattice").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("allowed");
            builder.suggest("config");
            builder.suggest("help");
            builder.suggest("illegal");
            builder.suggest("motd");
            builder.suggest("nick");
            builder.suggest("open");
            builder.suggest("pvp");
            builder.suggest("rules");
            builder.suggest("status");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            if (!action.equals("help")) {
                return 1;
            }
            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.help").method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10608(URI.create("https://github.com/lumentae/lattice")))).method_27692(class_124.field_1073));
            return 1;
        })).then(this.subCommand(dispatcher))));
    }

    public RequiredArgumentBuilder<class_2168, String> subCommand(CommandDispatcher<class_2168> dispatcher) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"subAction", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String action;
            switch (action = StringArgumentType.getString((CommandContext)context, (String)"action")) {
                case "config": {
                    builder.suggest("reload");
                    builder.suggest("save");
                    break;
                }
                case "status": 
                case "nick": 
                case "rules": 
                case "pvp": {
                    for (class_3222 player : Mod.getServer().method_3760().method_14571()) {
                        builder.suggest(player.method_5477().getString());
                    }
                    break;
                }
                case "motd": 
                case "illegal": 
                case "allowed": {
                    builder.suggest("add");
                    builder.suggest("list");
                    builder.suggest("remove");
                    break;
                }
                case "open": {
                    builder.suggest("end");
                    builder.suggest("nether");
                    builder.suggest("server");
                }
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"subActionArg", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String action = StringArgumentType.getString((CommandContext)context, (String)"action");
            String subAction = StringArgumentType.getString((CommandContext)context, (String)"subAction");
            switch (action) {
                case "status": 
                case "nick": {
                    builder.suggest("remove");
                    break;
                }
                case "rules": 
                case "pvp": {
                    builder.suggest("disable");
                    builder.suggest("enable");
                    break;
                }
                case "open": {
                    builder.suggest(LocalDateTime.now().toString());
                    switch (subAction) {
                        case "nether": {
                            builder.suggest(Config.INSTANCE.netherOpenDate.toString());
                            break;
                        }
                        case "end": {
                            builder.suggest(Config.INSTANCE.endOpenDate.toString());
                            break;
                        }
                        case "server": {
                            builder.suggest(Config.INSTANCE.serverOpenDate.toString());
                        }
                    }
                    break;
                }
                case "motd": {
                    if (!subAction.equals("remove")) break;
                    for (String motd : Config.INSTANCE.motds) {
                        builder.suggest(motd);
                    }
                    break;
                }
            }
            return builder.buildFuture();
        }).executes(commandContext -> {
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            String subAction = StringArgumentType.getString((CommandContext)commandContext, (String)"subAction");
            String subActionArg = StringArgumentType.getString((CommandContext)commandContext, (String)"subActionArg");
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            class_3222 searchedPlayer = Mod.getServer().method_3760().method_14566(subAction);
            block10 : switch (action) {
                case "status": {
                    switch (subActionArg) {
                        case "remove": {
                            StatusManager.removeStatus(searchedPlayer);
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.removed"));
                            break block10;
                        }
                    }
                    StatusManager.setStatus(searchedPlayer, subActionArg);
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.set").method_10852(StatusManager.getStatus(searchedPlayer)));
                    break;
                }
                case "nick": {
                    switch (subActionArg) {
                        case "remove": {
                            NicknameManager.removeNickname(searchedPlayer);
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.removed"));
                            break block10;
                        }
                    }
                    NicknameManager.setNickname(searchedPlayer, subActionArg);
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.set").method_27693(NicknameManager.getNickname(searchedPlayer)));
                    break;
                }
                case "rules": {
                    switch (subActionArg) {
                        case "enable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.method_5667()).acceptedRules = true;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.rules.enabled").method_10852(searchedPlayer.method_5477()).method_10852((class_2561)class_2561.method_43471((String)"message.lattice.now")));
                            break block10;
                        }
                        case "disable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.method_5667()).acceptedRules = false;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.rules.disabled").method_10852(searchedPlayer.method_5477()).method_10852((class_2561)class_2561.method_43471((String)"message.lattice.now")));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subActionArg).method_27692(class_124.field_1061));
                    break;
                }
                case "pvp": {
                    switch (subActionArg) {
                        case "enable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.method_5667()).enablePvP = true;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.pvp.enabled").method_10852(searchedPlayer.method_5477()).method_10852((class_2561)class_2561.method_43471((String)"message.lattice.now")));
                            break block10;
                        }
                        case "disable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.method_5667()).enablePvP = false;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.pvp.disabled").method_10852(searchedPlayer.method_5477()).method_10852((class_2561)class_2561.method_43471((String)"message.lattice.now")));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subActionArg).method_27692(class_124.field_1061));
                    break;
                }
                case "illegal": {
                    switch (subAction) {
                        case "add": {
                            Config.INSTANCE.illegalMods.add(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.add").method_27693(subActionArg));
                            break block10;
                        }
                        case "remove": {
                            Config.INSTANCE.illegalMods.remove(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.remove").method_27693(subActionArg));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                case "allowed": {
                    switch (subAction) {
                        case "add": {
                            Config.INSTANCE.allowedMods.add(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.add").method_27693(subActionArg));
                            break block10;
                        }
                        case "remove": {
                            Config.INSTANCE.allowedMods.remove(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.remove").method_27693(subActionArg));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                case "open": {
                    LocalDateTime parsed = TextUtils.parseDateString(subActionArg);
                    switch (subAction) {
                        case "nether": {
                            Config.INSTANCE.netherOpenDate = parsed;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.open.set").method_27693(parsed.toString()));
                            break block10;
                        }
                        case "end": {
                            Config.INSTANCE.endOpenDate = parsed;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.open.set").method_27693(parsed.toString()));
                            break block10;
                        }
                        case "server": {
                            Config.INSTANCE.serverOpenDate = parsed;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.open.set").method_27693(parsed.toString()));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                case "motd": {
                    switch (subAction) {
                        case "add": {
                            Config.INSTANCE.motds.add(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.add").method_27693(subActionArg));
                            break block10;
                        }
                        case "remove": {
                            Config.INSTANCE.motds.remove(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.remove").method_27693(subActionArg));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                default: {
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                }
            }
            return 1;
        }))).executes(commandContext -> {
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            String subAction = StringArgumentType.getString((CommandContext)commandContext, (String)"subAction");
            block10 : switch (action) {
                case "status": {
                    String status = Config.getPlayerPlayOptions((UUID)player.method_5667()).status;
                    if (status == null || status.isEmpty()) {
                        TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.none"));
                        return 1;
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.show").method_10852(StatusManager.getStatus(player)));
                    break;
                }
                case "nick": {
                    String nickname = Config.getPlayerPlayOptions((UUID)player.method_5667()).nickname;
                    if (nickname == null || nickname.isEmpty()) {
                        TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.none"));
                        return 1;
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.show").method_27693(NicknameManager.getNickname(player)));
                    break;
                }
                case "config": {
                    switch (subAction) {
                        case "save": {
                            Config.saveConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.config.save"));
                            break block10;
                        }
                        case "reload": {
                            Config.loadConfig();
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.config.reload"));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                case "rules": {
                    boolean acceptedRules = Config.getPlayerPlayOptions((UUID)player.method_5667()).acceptedRules;
                    if (acceptedRules) {
                        TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.rules.enabled").method_10852(player.method_5477()));
                        break;
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.rules.disabled").method_10852(player.method_5477()));
                    break;
                }
                case "pvp": {
                    boolean enablePvP = Config.getPlayerPlayOptions((UUID)player.method_5667()).enablePvP;
                    if (enablePvP) {
                        TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.pvp.enabled").method_10852(player.method_5477()));
                        break;
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.pvp.disabled").method_10852(player.method_5477()));
                    break;
                }
                case "motd": {
                    switch (subAction) {
                        case "list": {
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.list").method_27693(String.join((CharSequence)"\n- ", Config.INSTANCE.motds)));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                case "allowed": {
                    switch (subAction) {
                        case "list": {
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.list").method_27693(String.join((CharSequence)"\n- ", Config.INSTANCE.allowedMods)));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                case "illegal": {
                    switch (subAction) {
                        case "list": {
                            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.list").method_27693(String.join((CharSequence)"\n- ", Config.INSTANCE.illegalMods)));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                    break;
                }
                default: {
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27693(subAction).method_27692(class_124.field_1061));
                }
            }
            return 1;
        });
    }
}

