/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.mixin;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2614;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2614.class}, priority=-10000)
public class HopperBlockEntityMixin {
    @Unique
    private static String lattice$getItemName(String translationKey) {
        if (translationKey == null) {
            return null;
        }
        String[] names = translationKey.split("\\.");
        return names[names.length - 1];
    }

    @Unique
    private static boolean lattice$filterMatch(String filterString, String fullItemName, String itemCustomName) {
        String itemName = HopperBlockEntityMixin.lattice$getItemName(fullItemName);
        String[] filter = filterString.split(",");
        return Arrays.stream(filter).anyMatch(filter_i -> {
            if (filter_i.startsWith("$")) {
                return HopperBlockEntityMixin.lattice$tagMatch(itemName, filter_i.substring(1));
            }
            if (filter_i.startsWith("!")) {
                return !FilenameUtils.wildcardMatch((String)itemName, (String)filter_i.substring(1));
            }
            if (filter_i.contains("=")) {
                return HopperBlockEntityMixin.lattice$nameMatch(itemName, filter_i, itemCustomName);
            }
            return FilenameUtils.wildcardMatch((String)itemName, (String)filter_i);
        });
    }

    @Unique
    private static boolean lattice$tagMatch(String itemName, String filterI) {
        Optional itemOptional = class_7923.field_41178.method_10223(class_2960.method_60656((String)itemName));
        if (itemOptional.isEmpty()) {
            return false;
        }
        class_6880 item = (class_6880)itemOptional.get();
        List list = item.method_40228().toList();
        for (class_6862 tag : list) {
            if (!tag.comp_327().method_12832().equals(filterI)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static boolean lattice$nameMatch(String itemName, String filterI, String itemCustomName) {
        String[] split = filterI.split("=");
        if (split.length != 2) {
            return false;
        }
        String filterCustomName = split[1];
        return itemCustomName.equals(filterCustomName);
    }

    @Inject(method={"method_11247(Lnet/minecraft/class_1263;Lnet/minecraft/class_1542;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void lattice$pickup(class_1263 container, class_1542 itemEntity, CallbackInfoReturnable<Boolean> cir) {
        class_2614 hopperBlockEntity;
        if (!(container instanceof class_2614) || (hopperBlockEntity = (class_2614)container).method_5797() == null) {
            return;
        }
        String itemCustomName = "";
        if (itemEntity.method_5797() != null) {
            itemCustomName = itemEntity.method_5797().getString();
        }
        String itemName = HopperBlockEntityMixin.lattice$getItemName(itemEntity.method_6983().method_7909().method_7876());
        if (HopperBlockEntityMixin.lattice$filterMatch(hopperBlockEntity.method_5797().getString(), itemName, itemCustomName)) {
            return;
        }
        cir.cancel();
    }

    @Inject(method={"method_11260(Lnet/minecraft/class_1263;Lnet/minecraft/class_1263;Lnet/minecraft/class_1799;Lnet/minecraft/class_2350;)Lnet/minecraft/class_1799;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void lattice$transfer(class_1263 container, class_1263 container2, class_1799 itemStack, class_2350 direction, CallbackInfoReturnable<class_1799> cir) {
        class_2614 hopperBlockEntity;
        if (!(container2 instanceof class_2614) || (hopperBlockEntity = (class_2614)container2).method_5797() == null) {
            return;
        }
        String itemCustomName = "";
        if (itemStack.method_65130() != null) {
            itemCustomName = itemStack.method_65130().getString();
        }
        if (HopperBlockEntityMixin.lattice$filterMatch(hopperBlockEntity.method_5797().getString(), HopperBlockEntityMixin.lattice$getItemName(itemStack.method_7909().method_7876()), itemCustomName)) {
            return;
        }
        cir.setReturnValue((Object)itemStack);
    }
}

