/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import dev.lumentae.lattice.platform.Services;
import dev.lumentae.lattice.util.TextUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Config {
    public Map<UUID, PlayerPlayOptions> playerOptions = new HashMap<UUID, PlayerPlayOptions>();
    public static PlayerPlayOptions DEFAULT_PLAY_OPTIONS = new PlayerPlayOptions();
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().registerTypeAdapter(LocalDateTime.class, (json, type, jsonDeserializationContext) -> TextUtils.parseDateString(json.getAsJsonPrimitive().getAsString())).registerTypeAdapter(LocalDateTime.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))).create();
    public LocalDateTime serverOpenDate = LocalDateTime.now();
    public LocalDateTime endOpenDate = this.serverOpenDate.plusSeconds(864000L);
    public List<String> illegalMods = Arrays.asList("cheatbreaker", "impact", "lunar", "meteor", "nebulous", "salhack", "wurst", "future", "aristois", "bape", "xray", "x-ray", "freecam");
    public List<String> allowedMods = List.of("antixray");
    public ArrayList<String> motds;
    public ArrayList<String> offlineMotdPlayerNames;
    public ArrayList<String> rules = new ArrayList();
    public static Config INSTANCE = new Config();
    public static Path configPath = Services.PLATFORM.getConfigDirectory();
    public static Path configFilePath = configPath.resolve("config.json");
    public LocalDateTime netherOpenDate = this.serverOpenDate.plusSeconds(172800L);

    public static void saveConfig() {
        try {
            Files.writeString(configFilePath, (CharSequence)GSON.toJson((Object)INSTANCE), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadConfig() {
        try {
            if (!configFilePath.toFile().exists()) {
                Files.writeString(configFilePath, (CharSequence)GSON.toJson((Object)new Config()), new OpenOption[0]);
            }
            INSTANCE = (Config)GSON.fromJson(Files.readString(configFilePath), Config.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PlayerPlayOptions getPlayerPlayOptions(UUID uuid) {
        return Config.INSTANCE.playerOptions.computeIfAbsent(uuid, k -> new PlayerPlayOptions());
    }

    public static void setPlayerPlayOptions(UUID uuid, PlayerPlayOptions options) {
        Config.INSTANCE.playerOptions.put(uuid, options);
        Config.saveConfig();
    }

    public static class PlayerPlayOptions {
        public boolean enablePvP = true;
        public String nickname = null;
        public String status = "";
        public boolean acceptedRules = false;
    }
}

