/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.mojang.brigadier.CommandDispatcher;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Constants;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.command.ICommand;
import dev.lumentae.lattice.dispenser.DispenserBehavior;
import dev.lumentae.lattice.packet.ClientboundRulesPacket;
import dev.lumentae.lattice.packet.ServerboundAcceptedRulesPacket;
import dev.lumentae.lattice.packet.ServerboundModSharePacket;
import dev.lumentae.lattice.platform.Services;
import dev.lumentae.lattice.util.PacketUtils;
import dev.lumentae.lattice.util.Utils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;

public class Event {
    public static void OnServerStarted(MinecraftServer server) {
        Mod.setServer(server);
        ServerPlayer player = Services.PLATFORM.getFakePlayer(server);
        DispenseItemBehavior behaviors = DispenserBehavior.getDispenserBehavior(player);
        BuiltInRegistries.ITEM.forEach(item -> {
            if (DispenserBlock.DISPENSER_REGISTRY.containsKey(item)) {
                return;
            }
            DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)behaviors);
        });
    }

    public static void OnServerStopping(MinecraftServer server) {
        Mod.setServer(null);
        Config.saveConfig();
    }

    public static void OnRespawn(ServerPlayer player) {
        if (player.getLastDeathLocation().isEmpty()) {
            return;
        }
        GlobalPos o = (GlobalPos)player.getLastDeathLocation().get();
        player.sendSystemMessage((Component)Component.translatable((String)"message.lattice.death.1").append(String.valueOf(o.pos().getX())).append(", ").append(String.valueOf(o.pos().getY())).append(", ").append(String.valueOf(o.pos().getZ())).append((Component)Component.translatable((String)"message.lattice.death.2")));
    }

    public static void OnJoin(ServerGamePacketListenerImpl handler) {
        ServerPlayer player = handler.getPlayer();
        if (player.level().isClientSide()) {
            return;
        }
        Config.INSTANCE.playerOptions.computeIfAbsent(player.getUUID(), k -> Config.DEFAULT_PLAY_OPTIONS);
        if (Config.INSTANCE.serverOpenDate.isAfter(LocalDateTime.now()) && !player.hasPermissions(2)) {
            MutableComponent reason = Component.translatable((String)"message.lattice.server.closed.1").append((Component)Component.translatable((String)"message.lattice.server.closed.2")).append((Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(Config.INSTANCE.serverOpenDate.toString())).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append("!");
            ClientboundDisconnectPacket packet = new ClientboundDisconnectPacket((Component)reason);
            handler.send((Packet)packet);
        }
        if (!Config.INSTANCE.rules.isEmpty() && !Config.getPlayerPlayOptions((UUID)player.getUUID()).acceptedRules) {
            PacketUtils.sendToClient(player, ClientboundRulesPacket.create());
        }
    }

    public static void OnCommandRegister(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (ICommand command : Constants.COMMANDS) {
            command.register(dispatcher);
        }
    }

    public static void OnModSharePacket(ServerboundModSharePacket packet) {
        Constants.LOG.info("Received mod/resource pack list from server:");
        Constants.LOG.info("Origin: {} ({})", (Object)packet.origin(), (Object)Utils.getPlayerNameByUUID(UUID.fromString(packet.origin())));
        Constants.LOG.info("Mods: {}", (Object)packet.mods());
        Constants.LOG.info("Resource Packs: {}", (Object)packet.resourcePacks());
        if (Utils.containsIllegalMods(packet.mods()) || Utils.containsIllegalMods(packet.resourcePacks())) {
            Constants.LOG.warn("Illegal mods or resource packs!");
            ArrayList<String> illegalMods = new ArrayList<String>(packet.mods().lines().filter(Utils::containsIllegalMods).toList());
            illegalMods.addAll(packet.resourcePacks().lines().filter(Utils::containsIllegalMods).toList());
            ServerPlayer player = Utils.getPlayerByUUID(UUID.fromString(packet.origin()));
            if (player == null) {
                return;
            }
            MutableComponent reason = Component.translatable((String)"message.lattice.illegal_mods").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"\n- ")).append((Component)Component.literal((String)String.join((CharSequence)"\n- ", illegalMods)).withStyle(ChatFormatting.RED));
            player.connection.disconnect((Component)reason);
        }
    }

    public static void OnShareMods(Player player) {
        PacketUtils.sendToServer(ServerboundModSharePacket.create(player));
    }

    public static void OnAcceptedRulesPacket(ServerboundAcceptedRulesPacket data, ServerPlayer player) {
        if (!data.accepted()) {
            MutableComponent reason = Component.translatable((String)"message.lattice.rules.not_accepted").withStyle(ChatFormatting.RED);
            player.connection.disconnect((Component)reason);
            return;
        }
        Config.getPlayerPlayOptions((UUID)player.getUUID()).acceptedRules = true;
        Config.saveConfig();
    }
}

