/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.mojang.brigadier.CommandDispatcher;
import dev.lumentae.lattice.ClientEvent;
import dev.lumentae.lattice.Event;
import dev.lumentae.lattice.packet.ClientboundRulesPacket;
import dev.lumentae.lattice.packet.ServerboundAcceptedRulesPacket;
import dev.lumentae.lattice.packet.ServerboundModSharePacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="lattice")
public class EventHandler {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        Event.OnServerStarted(event.getServer());
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        Event.OnServerStopping(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Event.OnRespawn((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Event.OnJoin(((ServerPlayer)event.getEntity()).connection);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        Event.OnCommandRegister((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void handleDataForModShare(ServerboundModSharePacket data, IPayloadContext context) {
        context.enqueueWork(() -> Event.OnModSharePacket(data));
    }

    public static void handleDataForAcceptedRules(ServerboundAcceptedRulesPacket data, IPayloadContext context) {
        context.enqueueWork(() -> Event.OnAcceptedRulesPacket(data, (ServerPlayer)context.player()));
    }

    public static void handleDataForRules(ClientboundRulesPacket data, IPayloadContext context) {
        context.enqueueWork(() -> ClientEvent.OnRulesPacket(data));
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.commonToServer(ServerboundModSharePacket.TYPE, ServerboundModSharePacket.STREAM_CODEC, EventHandler::handleDataForModShare);
        registrar.commonToServer(ServerboundAcceptedRulesPacket.TYPE, ServerboundAcceptedRulesPacket.STREAM_CODEC, EventHandler::handleDataForAcceptedRules);
        registrar.commonToClient(ClientboundRulesPacket.TYPE, ClientboundRulesPacket.STREAM_CODEC, EventHandler::handleDataForRules);
    }
}

