/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.command.ICommand;
import dev.lumentae.lattice.nickname.NicknameManager;
import dev.lumentae.lattice.status.StatusManager;
import dev.lumentae.lattice.util.TextUtils;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class LatticeCommand
implements ICommand {
    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lattice").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("allowed");
            builder.suggest("config");
            builder.suggest("help");
            builder.suggest("illegal");
            builder.suggest("motd");
            builder.suggest("nick");
            builder.suggest("open");
            builder.suggest("pvp");
            builder.suggest("rules");
            builder.suggest("status");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            if (!action.equals("help")) {
                return 1;
            }
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.help").withStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://github.com/lumentae/lattice")))).withStyle(ChatFormatting.UNDERLINE));
            return 1;
        })).then(this.subCommand(dispatcher))));
    }

    public RequiredArgumentBuilder<CommandSourceStack, String> subCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"subAction", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String action;
            switch (action = StringArgumentType.getString((CommandContext)context, (String)"action")) {
                case "config": {
                    builder.suggest("reload");
                    builder.suggest("save");
                    break;
                }
                case "status": 
                case "nick": 
                case "rules": 
                case "pvp": {
                    for (ServerPlayer player : Mod.getServer().getPlayerList().getPlayers()) {
                        builder.suggest(player.getName().getString());
                    }
                    break;
                }
                case "motd": 
                case "illegal": 
                case "allowed": {
                    builder.suggest("add");
                    builder.suggest("list");
                    builder.suggest("remove");
                    break;
                }
                case "open": {
                    builder.suggest("end");
                    builder.suggest("nether");
                    builder.suggest("server");
                }
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"subActionArg", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String action = StringArgumentType.getString((CommandContext)context, (String)"action");
            String subAction = StringArgumentType.getString((CommandContext)context, (String)"subAction");
            switch (action) {
                case "status": 
                case "nick": {
                    builder.suggest("remove");
                    break;
                }
                case "rules": 
                case "pvp": {
                    builder.suggest("disable");
                    builder.suggest("enable");
                    break;
                }
                case "open": {
                    builder.suggest(LocalDateTime.now().toString());
                    switch (subAction) {
                        case "nether": {
                            builder.suggest(Config.INSTANCE.netherOpenDate.toString());
                            break;
                        }
                        case "end": {
                            builder.suggest(Config.INSTANCE.endOpenDate.toString());
                            break;
                        }
                        case "server": {
                            builder.suggest(Config.INSTANCE.serverOpenDate.toString());
                        }
                    }
                    break;
                }
                case "motd": {
                    if (!subAction.equals("remove")) break;
                    for (String motd : Config.INSTANCE.motds) {
                        builder.suggest(motd);
                    }
                    break;
                }
            }
            return builder.buildFuture();
        }).executes(commandContext -> {
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            String subAction = StringArgumentType.getString((CommandContext)commandContext, (String)"subAction");
            String subActionArg = StringArgumentType.getString((CommandContext)commandContext, (String)"subActionArg");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            ServerPlayer searchedPlayer = Mod.getServer().getPlayerList().getPlayerByName(subAction);
            block10 : switch (action) {
                case "status": {
                    switch (subActionArg) {
                        case "remove": {
                            StatusManager.removeStatus(searchedPlayer);
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.removed"));
                            break block10;
                        }
                    }
                    StatusManager.setStatus(searchedPlayer, subActionArg);
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.set").append(StatusManager.getStatus(searchedPlayer)));
                    break;
                }
                case "nick": {
                    switch (subActionArg) {
                        case "remove": {
                            NicknameManager.removeNickname(searchedPlayer);
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.removed"));
                            break block10;
                        }
                    }
                    NicknameManager.setNickname(searchedPlayer, subActionArg);
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.set").append(NicknameManager.getNickname(searchedPlayer)));
                    break;
                }
                case "rules": {
                    switch (subActionArg) {
                        case "enable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.getUUID()).acceptedRules = true;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.rules.enabled").append(searchedPlayer.getName()).append((Component)Component.translatable((String)"message.lattice.now")));
                            break block10;
                        }
                        case "disable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.getUUID()).acceptedRules = false;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.rules.disabled").append(searchedPlayer.getName()).append((Component)Component.translatable((String)"message.lattice.now")));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subActionArg).withStyle(ChatFormatting.RED));
                    break;
                }
                case "pvp": {
                    switch (subActionArg) {
                        case "enable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.getUUID()).enablePvP = true;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.pvp.enabled").append(searchedPlayer.getName()).append((Component)Component.translatable((String)"message.lattice.now")));
                            break block10;
                        }
                        case "disable": {
                            Config.getPlayerPlayOptions((UUID)searchedPlayer.getUUID()).enablePvP = false;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.pvp.disabled").append(searchedPlayer.getName()).append((Component)Component.translatable((String)"message.lattice.now")));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subActionArg).withStyle(ChatFormatting.RED));
                    break;
                }
                case "illegal": {
                    switch (subAction) {
                        case "add": {
                            Config.INSTANCE.illegalMods.add(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.add").append(subActionArg));
                            break block10;
                        }
                        case "remove": {
                            Config.INSTANCE.illegalMods.remove(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.remove").append(subActionArg));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                case "allowed": {
                    switch (subAction) {
                        case "add": {
                            Config.INSTANCE.allowedMods.add(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.add").append(subActionArg));
                            break block10;
                        }
                        case "remove": {
                            Config.INSTANCE.allowedMods.remove(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.remove").append(subActionArg));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                case "open": {
                    LocalDateTime parsed = TextUtils.parseDateString(subActionArg);
                    switch (subAction) {
                        case "nether": {
                            Config.INSTANCE.netherOpenDate = parsed;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.open.set").append(parsed.toString()));
                            break block10;
                        }
                        case "end": {
                            Config.INSTANCE.endOpenDate = parsed;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.open.set").append(parsed.toString()));
                            break block10;
                        }
                        case "server": {
                            Config.INSTANCE.serverOpenDate = parsed;
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.open.set").append(parsed.toString()));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                case "motd": {
                    switch (subAction) {
                        case "add": {
                            Config.INSTANCE.motds.add(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.add").append(subActionArg));
                            break block10;
                        }
                        case "remove": {
                            Config.INSTANCE.motds.remove(subActionArg);
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.remove").append(subActionArg));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                default: {
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                }
            }
            return 1;
        }))).executes(commandContext -> {
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            String subAction = StringArgumentType.getString((CommandContext)commandContext, (String)"subAction");
            block10 : switch (action) {
                case "status": {
                    String status = Config.getPlayerPlayOptions((UUID)player.getUUID()).status;
                    if (status == null || status.isEmpty()) {
                        TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.none"));
                        return 1;
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.show").append(StatusManager.getStatus(player)));
                    break;
                }
                case "nick": {
                    String nickname = Config.getPlayerPlayOptions((UUID)player.getUUID()).nickname;
                    if (nickname == null || nickname.isEmpty()) {
                        TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.none"));
                        return 1;
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.show").append(NicknameManager.getNickname(player)));
                    break;
                }
                case "config": {
                    switch (subAction) {
                        case "save": {
                            Config.saveConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.config.save"));
                            break block10;
                        }
                        case "reload": {
                            Config.loadConfig();
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.config.reload"));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                case "rules": {
                    boolean acceptedRules = Config.getPlayerPlayOptions((UUID)player.getUUID()).acceptedRules;
                    if (acceptedRules) {
                        TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.rules.enabled").append(player.getName()));
                        break;
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.rules.disabled").append(player.getName()));
                    break;
                }
                case "pvp": {
                    boolean enablePvP = Config.getPlayerPlayOptions((UUID)player.getUUID()).enablePvP;
                    if (enablePvP) {
                        TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.pvp.enabled").append(player.getName()));
                        break;
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.pvp.disabled").append(player.getName()));
                    break;
                }
                case "motd": {
                    switch (subAction) {
                        case "list": {
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.list").append(String.join((CharSequence)"\n- ", Config.INSTANCE.motds)));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                case "allowed": {
                    switch (subAction) {
                        case "list": {
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.list").append(String.join((CharSequence)"\n- ", Config.INSTANCE.allowedMods)));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                case "illegal": {
                    switch (subAction) {
                        case "list": {
                            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.list").append(String.join((CharSequence)"\n- ", Config.INSTANCE.illegalMods)));
                            break block10;
                        }
                    }
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                    break;
                }
                default: {
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").append(subAction).withStyle(ChatFormatting.RED));
                }
            }
            return 1;
        });
    }
}

