/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.dispenser;

import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class DispenserBehavior {
    @NotNull
    public static DispenseItemBehavior getDispenserBehavior(ServerPlayer player) {
        ServerPlayerGameMode manager = new ServerPlayerGameMode(player);
        manager.changeGameModeForPlayer(GameType.SURVIVAL);
        return (pointer, stack) -> {
            block5: {
                BlockPos relative;
                Direction direction;
                ServerLevel level;
                block6: {
                    block4: {
                        level = pointer.level();
                        player.setServerLevel(level);
                        player.setItemInHand(InteractionHand.MAIN_HAND, stack);
                        direction = (Direction)pointer.state().getValue((Property)DispenserBlock.FACING);
                        relative = pointer.pos().relative(direction, 1);
                        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(relative));
                        if (!stack.getItem().getDescriptionId().endsWith("_axe") && !stack.getItem().getDescriptionId().endsWith("sword") || entities.isEmpty()) break block4;
                        for (Entity entity : entities) {
                            int damage = Utils.getDamage(stack);
                            entity.hurt(level.damageSources().generic(), (float)damage);
                        }
                        break block5;
                    }
                    if (!stack.getItem().getDescriptionId().endsWith("axe") && !stack.getItem().getDescriptionId().endsWith("shovel")) break block6;
                    BlockState toBreak = level.getBlockState(relative);
                    if (!toBreak.is(BlockTags.MINEABLE_WITH_PICKAXE) && !toBreak.is(BlockTags.MINEABLE_WITH_AXE) && !toBreak.is(BlockTags.MINEABLE_WITH_SHOVEL)) break block5;
                    manager.destroyBlock(relative);
                    if (!Mod.usesDurability) {
                        stack.setDamageValue(stack.getDamageValue() - 1);
                    }
                    break block5;
                }
                if (!(stack.getItem() instanceof BlockItem)) break block5;
                Direction direction2 = level.isEmptyBlock(relative) ? direction : Direction.UP;
                try {
                    ((BlockItem)stack.getItem()).place((BlockPlaceContext)new DirectionalPlaceContext((Level)level, relative, direction, stack, direction2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return stack;
        };
    }
}

