/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.motd;

import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.nickname.NicknameManager;
import dev.lumentae.lattice.util.Utils;
import net.minecraft.server.level.ServerPlayer;

public class MotdManager {
    public static void changeMotd() {
        String newMotd = MotdManager.formatMotd(MotdManager.getRandomMotd());
        Mod.getServer().setMotd(newMotd);
    }

    private static String getRandomMotd() {
        if (Config.INSTANCE.motds == null || Config.INSTANCE.motds.isEmpty()) {
            return Mod.getServer().getMotd();
        }
        return Config.INSTANCE.motds.get((int)(Math.random() * (double)Config.INSTANCE.motds.size()));
    }

    private static String formatMotd(String motd) {
        String playerName;
        if (!motd.contains("{randomPlayer}")) {
            return motd;
        }
        if (Mod.getServer().getPlayerList().getPlayers().size() <= 2) {
            playerName = Config.INSTANCE.offlineMotdPlayerNames == null || Config.INSTANCE.offlineMotdPlayerNames.isEmpty() ? "Player" : Utils.getRandom(Config.INSTANCE.offlineMotdPlayerNames);
        } else {
            ServerPlayer randomPlayer = Utils.getRandomPlayer();
            assert (randomPlayer != null);
            playerName = NicknameManager.getNickname(randomPlayer);
        }
        return motd.replace("{randomPlayer}", playerName);
    }
}

