/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.platform;

import com.mojang.authlib.GameProfile;
import dev.lumentae.lattice.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.util.FakePlayer;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public Path getConfigDirectory() {
        return FMLLoader.getCurrent().getGameDir().resolve("config").resolve("lattice");
    }

    @Override
    public ServerPlayer getFakePlayer(MinecraftServer server) {
        UUID defaultUUID = UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77");
        return new FakePlayer(server.overworld(), new GameProfile(defaultUUID, "[Minecraft]"));
    }

    @Override
    public ArrayList<String> getModList() {
        ArrayList<String> mods = new ArrayList<String>();
        ModList.get().getMods().forEach(modContainer -> mods.add(modContainer.getModId()));
        return mods;
    }

    @Override
    public String getSide() {
        return FMLLoader.getCurrent().getDist().toString().toLowerCase();
    }
}

