/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.util;

import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Mod;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class Utils {
    public static String getPlayerNameByUUID(UUID playerUUID) {
        AtomicReference<String> returnVal = new AtomicReference<String>(playerUUID.toString());
        Objects.requireNonNull(Mod.getServer().services().profileResolver()).fetchById(playerUUID).ifPresent(profile -> returnVal.set(profile.name()));
        return returnVal.get();
    }

    public static ServerPlayer getPlayerByUUID(UUID playerUUID) {
        return Mod.getServer().getPlayerList().getPlayer(playerUUID);
    }

    public static int getDamage(ItemStack stack) {
        List modifiers = ((ItemAttributeModifiers)stack.getComponents().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).modifiers();
        for (ItemAttributeModifiers.Entry entry : modifiers) {
            if (!((Attribute)entry.attribute().value()).getDescriptionId().endsWith("attack_damage")) continue;
            return Double.valueOf(entry.modifier().amount()).intValue();
        }
        return 0;
    }

    public static boolean containsIllegalMods(String mods) {
        List<String> modsList = List.of(mods.toLowerCase().split("\\|"));
        for (String illegalMod : Config.INSTANCE.illegalMods) {
            for (String mod : modsList) {
                if (!mod.contains(illegalMod) || Config.INSTANCE.allowedMods.contains(mod)) continue;
                return true;
            }
        }
        return false;
    }

    public static ServerPlayer getRandomPlayer() {
        List players = Mod.getServer().getPlayerList().getPlayers();
        if (players.isEmpty()) {
            return null;
        }
        return (ServerPlayer)players.get((int)(Math.random() * (double)players.size()));
    }

    public static <T> T getRandom(List<T> obj) {
        return obj.get((int)(Math.random() * (double)obj.size()));
    }
}

