/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.lumentae.lattice.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Config {
    public Map<UUID, PlayerPlayOptions> playerOptions = new HashMap<UUID, PlayerPlayOptions>();
    public Date serverOpenDate = Date.from(Instant.now().plusSeconds(86400L));
    public Date endOpenDate = Date.from(this.serverOpenDate.toInstant().plusSeconds(864000L));
    public static PlayerPlayOptions DEFAULT_PLAY_OPTIONS = new PlayerPlayOptions();
    public List<String> illegalMods = Arrays.asList("cheatbreaker", "impact", "lunar", "meteor", "nebulous", "salhack", "wurst", "future", "aristois", "bape", "xray", "x-ray", "freecam");
    public ArrayList<String> motds;
    public ArrayList<String> offlineMotdPlayerNames;
    public static Config INSTANCE = new Config();
    public static Path configPath = Services.PLATFORM.getConfigDirectory();
    public static Path configFilePath = configPath.resolve("config.json");
    public static Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();

    public static void loadConfig() {
        try {
            if (!configFilePath.toFile().exists()) {
                Files.writeString(configFilePath, (CharSequence)gson.toJson((Object)new Config()), new OpenOption[0]);
            }
            INSTANCE = (Config)gson.fromJson(Files.readString(configFilePath), Config.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PlayerPlayOptions getPlayerPlayOptions(UUID uuid) {
        return Config.INSTANCE.playerOptions.computeIfAbsent(uuid, k -> new PlayerPlayOptions());
    }

    public static void saveConfig() {
        try {
            Files.writeString(configFilePath, (CharSequence)gson.toJson((Object)INSTANCE), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setPlayerPlayOptions(UUID uuid, PlayerPlayOptions options) {
        Config.INSTANCE.playerOptions.put(uuid, options);
        Config.saveConfig();
    }

    public static void removePlayerPlayOptions(UUID uuid) {
        Config.INSTANCE.playerOptions.remove(uuid);
        Config.saveConfig();
    }

    public static class PlayerPlayOptions {
        public boolean enablePvP = true;
        public String nickname = null;
        public String status = "";
    }
}

