/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Constants;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.dispenser.DispenserBehavior;
import dev.lumentae.lattice.nickname.NicknameManager;
import dev.lumentae.lattice.packet.ServerboundModSharePacket;
import dev.lumentae.lattice.platform.Services;
import dev.lumentae.lattice.status.StatusManager;
import dev.lumentae.lattice.util.PacketUtils;
import dev.lumentae.lattice.util.TextUtils;
import dev.lumentae.lattice.util.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;

public class Event {
    public static void OnServerStarted(MinecraftServer server) {
        Mod.setServer(server);
        ServerPlayer player = Services.PLATFORM.getFakePlayer(server);
        DispenseItemBehavior behaviors = DispenserBehavior.getDispenserBehavior(player);
        BuiltInRegistries.ITEM.forEach(item -> {
            if (DispenserBlock.DISPENSER_REGISTRY.containsKey(item)) {
                return;
            }
            DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)behaviors);
        });
    }

    public static void OnServerStopping(MinecraftServer server) {
        Mod.setServer(null);
        Config.saveConfig();
    }

    public static void OnRespawn(ServerPlayer player) {
        if (player.getLastDeathLocation().isEmpty()) {
            return;
        }
        GlobalPos o = (GlobalPos)player.getLastDeathLocation().get();
        player.sendSystemMessage((Component)Component.translatable((String)"message.lattice.death.1").append(String.valueOf(o.pos().getX())).append(", ").append(String.valueOf(o.pos().getY())).append(", ").append(String.valueOf(o.pos().getZ())).append((Component)Component.translatable((String)"message.lattice.death.2")));
    }

    public static void OnJoin(ServerGamePacketListenerImpl handler) {
        ServerPlayer player = handler.getPlayer();
        if (player.level().isClientSide) {
            return;
        }
        Config.INSTANCE.playerOptions.computeIfAbsent(player.getUUID(), k -> Config.DEFAULT_PLAY_OPTIONS);
        if (Config.INSTANCE.serverOpenDate.after(new Date()) && !player.hasPermissions(2)) {
            MutableComponent reason = Component.translatable((String)"message.lattice.server.closed.1").append((Component)Component.translatable((String)"message.lattice.server.closed.2")).append((Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(Config.INSTANCE.serverOpenDate.toString())).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append("!");
            ClientboundDisconnectPacket packet = new ClientboundDisconnectPacket((Component)reason);
            handler.send((Packet)packet);
        }
    }

    public static void OnCommandRegister(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"nv").executes(commandContext -> {
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            assert (player != null);
            if (player.hasEffect(MobEffects.NIGHT_VISION)) {
                player.removeEffect(MobEffects.NIGHT_VISION);
                return 1;
            }
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, -1, 255, false, false));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lattice").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("save");
            builder.suggest("reload");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            assert (player != null);
            switch (action) {
                case "save": {
                    Config.saveConfig();
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.save"));
                    return 1;
                }
                case "reload": {
                    Config.loadConfig();
                    TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.reload"));
                    return 1;
                }
            }
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.lattice.unknown").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)action)));
            return 0;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nick").then(Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            assert (player != null);
            builder.suggest(player.getName().getString());
            return builder.buildFuture();
        }).executes(commandContext -> {
            String nickname = StringArgumentType.getString((CommandContext)commandContext, (String)"nickname");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            assert (player != null);
            if (nickname.equals(player.getName().getString())) {
                NicknameManager.removeNickname(player);
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.removed").withStyle(ChatFormatting.GREEN));
                return 1;
            }
            NicknameManager.setNickname(player, nickname);
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.set").append((Component)Component.literal((String)nickname).withStyle(ChatFormatting.GREEN)));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            assert (player != null);
            String name = Config.getPlayerPlayOptions((UUID)player.getUUID()).nickname;
            if (name == null) {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.none").withStyle(ChatFormatting.RED));
            } else {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.show").append((Component)Component.literal((String)name).withStyle(ChatFormatting.GREEN)));
            }
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"status").then(Commands.argument((String)"status", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            builder.suggest("reset");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String status = StringArgumentType.getString((CommandContext)commandContext, (String)"status");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            assert (player != null);
            if (status.equals("reset")) {
                StatusManager.removeStatus(player);
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.removed").withStyle(ChatFormatting.GREEN));
                return 1;
            }
            StatusManager.setStatus(player, status);
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.set").append(TextUtils.parseColoredText(status)));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            assert (player != null);
            String status = Config.getPlayerPlayOptions((UUID)player.getUUID()).status;
            if (status == null) {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.none").withStyle(ChatFormatting.RED));
            } else {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.show").append((Component)Component.literal((String)status)));
            }
            return 1;
        }));
    }

    public static void OnModSharePacket(ServerboundModSharePacket packet) {
        Constants.LOG.info("Received mod/resource pack list from server:");
        Constants.LOG.info("Origin: {} ({})", (Object)packet.origin(), (Object)Utils.getPlayerNameByUUID(UUID.fromString(packet.origin())));
        Constants.LOG.info("Mods: {}", (Object)packet.mods());
        Constants.LOG.info("Resource Packs: {}", (Object)packet.resourcePacks());
        if (Utils.containsIllegalMods(packet.mods()) || Utils.containsIllegalMods(packet.resourcePacks())) {
            Constants.LOG.warn("Illegal mods or resource packs!");
            ArrayList<String> illegalMods = new ArrayList<String>(packet.mods().replace('|', '\n').lines().filter(Utils::containsIllegalMods).toList());
            illegalMods.addAll(packet.resourcePacks().replace('|', '\n').lines().filter(Utils::containsIllegalMods).toList());
            ServerPlayer player = Utils.getPlayerByUUID(UUID.fromString(packet.origin()));
            if (player != null) {
                ClientboundDisconnectPacket kickPacket = new ClientboundDisconnectPacket((Component)Component.translatable((String)"message.lattice.illegal_mods").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"\n- ")).append((Component)Component.literal((String)String.join((CharSequence)"\n- ", illegalMods)).withStyle(ChatFormatting.RED)));
                player.connection.send((Packet)kickPacket);
                player.connection.disconnect((Component)Component.translatable((String)"message.lattice.illegal_mods").withStyle(ChatFormatting.RED));
            }
        }
    }

    public static void OnShareMods(Player player) {
        PacketUtils.sendToServer(ServerboundModSharePacket.create(player));
    }
}

