/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.decorator;

import dev.lumentae.lattice.nickname.NicknameManager;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratorManager
implements ChatDecorator {
    public static final ChatDecorator DECORATOR = new DecoratorManager();
    private static final ArrayList<ChatDecorator> decorators = new ArrayList();

    public static void registerDecorator(ChatDecorator decorator) {
        decorators.add(decorator);
    }

    @NotNull
    public MutableComponent decorate(@Nullable ServerPlayer serverPlayer, @NotNull Component component) {
        assert (serverPlayer != null);
        MutableComponent base = Component.empty();
        for (ChatDecorator decorator : decorators) {
            base.append(decorator.decorate(serverPlayer, component));
        }
        String playerName = NicknameManager.getNickname(serverPlayer);
        base.append((Component)Component.literal((String)"<").append((Component)Component.literal((String)playerName).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)serverPlayer.getName())))).append((Component)Component.literal((String)"> ")).append(component).withStyle(ChatFormatting.RESET));
        return base;
    }
}

