/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.mixin;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlockEntity.class}, priority=-10000)
public class HopperBlockEntityMixin {
    @Unique
    private static String lattice$getItemName(String translationKey) {
        if (translationKey == null) {
            return null;
        }
        String[] names = translationKey.split("\\.");
        return names[names.length - 1];
    }

    @Unique
    private static boolean lattice$filterMatch(String filterString, String fullItemName, String itemCustomName) {
        String itemName = HopperBlockEntityMixin.lattice$getItemName(fullItemName);
        String[] filter = filterString.split(",");
        return Arrays.stream(filter).anyMatch(filter_i -> {
            if (filter_i.startsWith("$")) {
                return HopperBlockEntityMixin.lattice$tagMatch(itemName, filter_i.substring(1));
            }
            if (filter_i.startsWith("!")) {
                return !FilenameUtils.wildcardMatch((String)itemName, (String)filter_i.substring(1));
            }
            if (filter_i.contains("=")) {
                return HopperBlockEntityMixin.lattice$nameMatch(itemName, filter_i, itemCustomName);
            }
            return FilenameUtils.wildcardMatch((String)itemName, (String)filter_i);
        });
    }

    @Unique
    private static boolean lattice$tagMatch(String itemName, String filterI) {
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)itemName));
        List<Field> fields = Arrays.stream(ItemTags.class.getFields()).toList();
        for (Field field : fields) {
            String filter;
            String name = field.getName();
            if (!name.equals(filter = filterI.toUpperCase())) continue;
            try {
                TagKey tag = (TagKey)field.get(null);
                return new ItemStack((ItemLike)item).is(tag);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Unique
    private static boolean lattice$nameMatch(String itemName, String filterI, String itemCustomName) {
        String[] split = filterI.split("=");
        if (split.length != 2) {
            return false;
        }
        String filterCustomName = split[1];
        return itemCustomName.equals(filterCustomName);
    }

    @Inject(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addItem(Container container, ItemEntity itemEntity, CallbackInfoReturnable<Boolean> cir) {
        HopperBlockEntity hopperBlockEntity;
        if (!(container instanceof HopperBlockEntity) || (hopperBlockEntity = (HopperBlockEntity)container).getCustomName() == null) {
            return;
        }
        String itemCustomName = "";
        if (itemEntity.getCustomName() != null) {
            itemCustomName = itemEntity.getCustomName().getString();
        }
        String itemName = HopperBlockEntityMixin.lattice$getItemName(itemEntity.getItem().getItem().getDescriptionId());
        if (HopperBlockEntityMixin.lattice$filterMatch(hopperBlockEntity.getCustomName().getString(), itemName, itemCustomName)) {
            return;
        }
        cir.cancel();
    }

    @Inject(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addItem(Container container, Container container2, ItemStack itemStack, Direction direction, CallbackInfoReturnable<ItemStack> cir) {
        HopperBlockEntity hopperBlockEntity;
        if (!(container2 instanceof HopperBlockEntity) || (hopperBlockEntity = (HopperBlockEntity)container2).getCustomName() == null) {
            return;
        }
        String itemCustomName = "";
        assert (itemStack.getEntityRepresentation() != null);
        if (itemStack.getEntityRepresentation().getCustomName() != null) {
            itemCustomName = itemStack.getEntityRepresentation().getCustomName().getString();
        }
        if (HopperBlockEntityMixin.lattice$filterMatch(hopperBlockEntity.getCustomName().getString(), HopperBlockEntityMixin.lattice$getItemName(itemStack.getItem().getDescriptionId()), itemCustomName)) {
            return;
        }
        cir.setReturnValue((Object)itemStack);
    }
}

