/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.util;

import dev.lumentae.lattice.Mod;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class TextUtils {
    public static void sendMessage(ServerPlayer player, MutableComponent message) {
        MutableComponent startComponent = TextUtils.createGradient("[lattice]", 0xFF5555, 0xFFAA00, true).append((Component)Component.literal((String)" ")).withStyle(ChatFormatting.RESET).append((Component)Component.literal((String)"\u00bb ").withStyle(ChatFormatting.GRAY));
        player.sendSystemMessage((Component)startComponent.append((Component)message.withStyle(ChatFormatting.WHITE)));
    }

    public static MutableComponent createGradient(String text, int startColor, int endColor, boolean bold) {
        MutableComponent result = Component.empty();
        int length = text.length();
        if (length == 0) {
            return result;
        }
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            float t = length == 1 ? 0.0f : (float)i / (float)(length - 1);
            int r = (int)((float)startR + t * (float)(endR - startR));
            int g = (int)((float)startG + t * (float)(endG - startG));
            int b = (int)((float)startB + t * (float)(endB - startB));
            int rgb = r << 16 | g << 8 | b;
            MutableComponent part = Component.literal((String)String.valueOf(c)).withStyle(Style.EMPTY.withColor(rgb));
            if (bold) {
                part = part.withStyle(ChatFormatting.BOLD);
            }
            result.append((Component)part);
        }
        return result;
    }

    public static MutableComponent fromString(String text) {
        return Component.Serializer.fromJson((String)text, (HolderLookup.Provider)Mod.getServer().registryAccess());
    }

    public static Component parseColoredText(String text) {
        MutableComponent result;
        if (text.isEmpty()) {
            return Component.literal((String)"");
        }
        if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        if ((result = TextUtils.fromString(text)) == null) {
            result = Component.literal((String)text);
        }
        return result;
    }
}

