/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.discord;

import dev.caoimhe.jdiscordipc.JDiscordIPC;
import dev.caoimhe.jdiscordipc.activity.model.Activity;
import dev.caoimhe.jdiscordipc.activity.model.ActivityBuilder;
import dev.caoimhe.jdiscordipc.activity.model.ActivityTimestamps;
import dev.caoimhe.jdiscordipc.activity.model.ActivityType;
import dev.caoimhe.jdiscordipc.activity.model.party.ActivityPartyPrivacy;
import dev.caoimhe.jdiscordipc.event.DiscordEventListener;
import dev.caoimhe.jdiscordipc.event.model.ReadyEvent;
import dev.caoimhe.jdiscordipc.exception.JDiscordIPCException;
import dev.caoimhe.jdiscordipc.modern.socket.ModernSystemSocketFactory;
import dev.caoimhe.jdiscordipc.socket.SystemSocketFactory;
import dev.lumentae.lattice.ClientEvent;
import dev.lumentae.lattice.Constants;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.discord.DiscordRpcConfiguration;
import java.time.Instant;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;

public class DiscordRpcManager
implements DiscordEventListener {
    private static final Timer timer = new Timer();
    public static DiscordRpcConfiguration discordRpcConfiguration;
    private static JDiscordIPC jDiscordIPC;
    private static Activity activity;

    public static void initialize(DiscordRpcConfiguration rpcConfiguration) {
        Constants.LOG.info("Initializing Discord RPC.");
        jDiscordIPC = JDiscordIPC.builder((long)rpcConfiguration.applicationId()).systemSocketFactory((SystemSocketFactory)new ModernSystemSocketFactory()).build();
        discordRpcConfiguration = rpcConfiguration;
        DiscordRpcManager.updateActivity();
        try {
            jDiscordIPC.connect();
        }
        catch (JDiscordIPCException.DiscordClientUnavailableException e) {
            Constants.LOG.error("Failed to connect to a Discord client.", (Throwable)e);
        }
        jDiscordIPC.registerEventListener((DiscordEventListener)new DiscordRpcManager());
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DiscordRpcManager.updateActivity();
            }
        }, 0L, 5000L);
    }

    public static void updateActivity() {
        try {
            ActivityBuilder activityBuilder = Activity.builder().details(discordRpcConfiguration.details()).state(discordRpcConfiguration.state()).assets(assets -> {
                if (!discordRpcConfiguration.smallImageKey().isEmpty() && !discordRpcConfiguration.smallImageText().isEmpty()) {
                    assets.smallImage(discordRpcConfiguration.smallImageKey(), discordRpcConfiguration.smallImageText());
                } else if (ClientEvent.client.field_1724 != null) {
                    assets.smallImage("https://crafthead.net/helm/" + String.valueOf(ClientEvent.client.field_1724.method_5667()), ClientEvent.client.field_1724.method_5476().getString());
                }
                if (!discordRpcConfiguration.largeImageKey().isEmpty() && !discordRpcConfiguration.largeImageText().isEmpty()) {
                    assets.largeImage(discordRpcConfiguration.largeImageKey(), discordRpcConfiguration.largeImageText());
                }
            }).timestamps(ActivityTimestamps.from((Instant)Mod.START_TIME)).type(ActivityType.PLAYING);
            if (ClientEvent.client.method_1562() != null) {
                int maxPlayers;
                Object ip = "Singleplayer";
                if (ClientEvent.client.method_1558() != null) {
                    maxPlayers = ClientEvent.client.method_1558().field_41861 != null ? ClientEvent.client.method_1558().field_41861.comp_1279() : 1;
                    ip = "on " + Objects.requireNonNull(ClientEvent.client.method_1558()).field_3761;
                } else {
                    maxPlayers = 1;
                }
                assert (ClientEvent.client.field_1724 != null);
                activityBuilder = activityBuilder.party("party", ClientEvent.client.method_1562().method_2880().size(), builder -> {
                    builder.maximumSize(maxPlayers);
                    builder.privacy(ActivityPartyPrivacy.PUBLIC);
                }).state("Playing " + (String)ip).details(DiscordRpcManager.getCorrectDimensionString((class_5321<class_1937>)ClientEvent.client.field_1724.method_73183().method_27983()) + " " + class_2561.method_43469((String)"message.lattice.discord.at_coords", (Object[])new Object[]{(int)ClientEvent.client.field_1724.method_23317(), (int)ClientEvent.client.field_1724.method_23318(), (int)ClientEvent.client.field_1724.method_23321()}).getString());
            }
            activity = activityBuilder.build();
            jDiscordIPC.updateActivity(activity);
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to update Discord RPC activity", (Throwable)e);
        }
    }

    private static String getCorrectDimensionString(class_5321<class_1937> dimension) {
        switch (dimension.method_29177().toString()) {
            case "minecraft:overworld": {
                return class_2561.method_43471((String)"message.lattice.discord.in_overworld").getString();
            }
            case "minecraft:the_nether": {
                return class_2561.method_43471((String)"message.lattice.discord.in_nether").getString();
            }
            case "minecraft:the_end": {
                return class_2561.method_43471((String)"message.lattice.discord.in_end").getString();
            }
        }
        return dimension.method_29177().toString();
    }

    public void onReadyEvent(ReadyEvent event) {
        Constants.LOG.info("Connected to Discord RPC.");
        jDiscordIPC.updateActivity(activity);
    }
}

