/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.command.ICommand;
import dev.lumentae.lattice.nickname.NicknameManager;
import dev.lumentae.lattice.util.TextUtils;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class NickCommand
implements ICommand {
    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nick").then(Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            assert (player != null);
            builder.suggest(player.getName().getString());
            return builder.buildFuture();
        }).executes(commandContext -> {
            String nickname = StringArgumentType.getString((CommandContext)commandContext, (String)"nickname");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            assert (player != null);
            if (nickname.equals(player.getName().getString())) {
                NicknameManager.removeNickname(player);
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.removed").withStyle(ChatFormatting.GREEN));
                return 1;
            }
            NicknameManager.setNickname(player, nickname);
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.set").append((Component)Component.literal((String)nickname).withStyle(ChatFormatting.GREEN)));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            assert (player != null);
            String name = Config.getPlayerPlayOptions((UUID)player.getUUID()).nickname;
            if (name == null) {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.none").withStyle(ChatFormatting.RED));
            } else {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.nickname.show").append((Component)Component.literal((String)name).withStyle(ChatFormatting.GREEN)));
            }
            return 1;
        }));
    }
}

