/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.command.ICommand;
import dev.lumentae.lattice.status.StatusManager;
import dev.lumentae.lattice.util.TextUtils;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class StatusCommand
implements ICommand {
    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"status").then(Commands.argument((String)"status", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            builder.suggest("reset");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String status = StringArgumentType.getString((CommandContext)commandContext, (String)"status");
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            assert (player != null);
            if (status.equals("reset")) {
                StatusManager.removeStatus(player);
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.removed").withStyle(ChatFormatting.GREEN));
                return 1;
            }
            StatusManager.setStatus(player, status);
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.set").append(TextUtils.parseColoredText(status)));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            assert (player != null);
            String status = Config.getPlayerPlayOptions((UUID)player.getUUID()).status;
            if (status == null) {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.none").withStyle(ChatFormatting.RED));
            } else {
                TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.status.show").append((Component)Component.literal((String)status)));
            }
            return 1;
        }));
    }
}

