/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.discord;

import dev.caoimhe.jdiscordipc.JDiscordIPC;
import dev.caoimhe.jdiscordipc.activity.model.Activity;
import dev.caoimhe.jdiscordipc.activity.model.ActivityBuilder;
import dev.caoimhe.jdiscordipc.activity.model.ActivityTimestamps;
import dev.caoimhe.jdiscordipc.activity.model.ActivityType;
import dev.caoimhe.jdiscordipc.activity.model.party.ActivityPartyPrivacy;
import dev.caoimhe.jdiscordipc.event.DiscordEventListener;
import dev.caoimhe.jdiscordipc.event.model.ReadyEvent;
import dev.caoimhe.jdiscordipc.exception.JDiscordIPCException;
import dev.caoimhe.jdiscordipc.modern.socket.ModernSystemSocketFactory;
import dev.caoimhe.jdiscordipc.socket.SystemSocketFactory;
import dev.lumentae.lattice.ClientEvent;
import dev.lumentae.lattice.Constants;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.discord.DiscordRpcConfiguration;
import java.time.Instant;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DiscordRpcManager
implements DiscordEventListener {
    private static final Timer timer = new Timer();
    public static DiscordRpcConfiguration discordRpcConfiguration;
    private static JDiscordIPC jDiscordIPC;
    private static Activity activity;

    public static void initialize(DiscordRpcConfiguration rpcConfiguration) {
        Constants.LOG.info("Initializing Discord RPC.");
        jDiscordIPC = JDiscordIPC.builder((long)rpcConfiguration.applicationId()).systemSocketFactory((SystemSocketFactory)new ModernSystemSocketFactory()).build();
        discordRpcConfiguration = rpcConfiguration;
        DiscordRpcManager.updateActivity();
        try {
            jDiscordIPC.connect();
        }
        catch (JDiscordIPCException.DiscordClientUnavailableException e) {
            Constants.LOG.error("Failed to connect to a Discord client.", (Throwable)e);
        }
        jDiscordIPC.registerEventListener((DiscordEventListener)new DiscordRpcManager());
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DiscordRpcManager.updateActivity();
            }
        }, 0L, 5000L);
    }

    public static void updateActivity() {
        try {
            ActivityBuilder activityBuilder = Activity.builder().details(discordRpcConfiguration.details()).state(discordRpcConfiguration.state()).assets(assets -> {
                if (!discordRpcConfiguration.smallImageKey().isEmpty() && !discordRpcConfiguration.smallImageText().isEmpty()) {
                    assets.smallImage(discordRpcConfiguration.smallImageKey(), discordRpcConfiguration.smallImageText());
                } else if (ClientEvent.client.player != null) {
                    assets.smallImage("https://crafthead.net/helm/" + String.valueOf(ClientEvent.client.player.getUUID()), ClientEvent.client.player.getDisplayName().getString());
                }
                if (!discordRpcConfiguration.largeImageKey().isEmpty() && !discordRpcConfiguration.largeImageText().isEmpty()) {
                    assets.largeImage(discordRpcConfiguration.largeImageKey(), discordRpcConfiguration.largeImageText());
                }
            }).timestamps(ActivityTimestamps.from((Instant)Mod.START_TIME)).type(ActivityType.PLAYING);
            if (ClientEvent.client.getConnection() != null) {
                int maxPlayers;
                Object ip = "Singleplayer";
                if (ClientEvent.client.getCurrentServer() != null) {
                    maxPlayers = ClientEvent.client.getCurrentServer().players != null ? ClientEvent.client.getCurrentServer().players.max() : 1;
                    ip = "on " + Objects.requireNonNull(ClientEvent.client.getCurrentServer()).ip;
                } else {
                    maxPlayers = 1;
                }
                assert (ClientEvent.client.player != null);
                activityBuilder = activityBuilder.party("party", ClientEvent.client.getConnection().getOnlinePlayers().size(), builder -> {
                    builder.maximumSize(maxPlayers);
                    builder.privacy(ActivityPartyPrivacy.PUBLIC);
                }).state("Playing " + (String)ip).details(DiscordRpcManager.getCorrectDimensionString((ResourceKey<Level>)ClientEvent.client.player.level().dimension()) + " " + Component.translatable((String)"message.lattice.discord.at_coords", (Object[])new Object[]{(int)ClientEvent.client.player.getX(), (int)ClientEvent.client.player.getY(), (int)ClientEvent.client.player.getZ()}).getString());
            }
            activity = activityBuilder.build();
            jDiscordIPC.updateActivity(activity);
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to update Discord RPC activity", (Throwable)e);
        }
    }

    private static String getCorrectDimensionString(ResourceKey<Level> dimension) {
        switch (dimension.location().toString()) {
            case "minecraft:overworld": {
                return Component.translatable((String)"message.lattice.discord.in_overworld").getString();
            }
            case "minecraft:the_nether": {
                return Component.translatable((String)"message.lattice.discord.in_nether").getString();
            }
            case "minecraft:the_end": {
                return Component.translatable((String)"message.lattice.discord.in_end").getString();
            }
        }
        return dimension.location().toString();
    }

    public void onReadyEvent(ReadyEvent event) {
        Constants.LOG.info("Connected to Discord RPC.");
        jDiscordIPC.updateActivity(activity);
    }
}

