/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice.mixin;

import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.util.TextUtils;
import java.time.LocalDateTime;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.portal.TeleportTransition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PortalProcessor.class})
public class PortalProcessorMixin {
    @Shadow
    private Portal portal;
    @Shadow
    private BlockPos entryPosition;

    @Inject(method={"getPortalDestination"}, at={@At(value="HEAD")}, cancellable=true)
    private void init(ServerLevel level, Entity entity, CallbackInfoReturnable<TeleportTransition> cir) {
        boolean isInClosedDimension;
        TeleportTransition transition = this.portal.getPortalDestination(level, entity, this.entryPosition);
        assert (transition != null);
        ResourceKey newDimension = transition.newLevel().dimension();
        boolean bl = isInClosedDimension = newDimension == Level.END && Config.INSTANCE.endOpenDate.isAfter(LocalDateTime.now()) || newDimension == Level.NETHER && Config.INSTANCE.netherOpenDate.isAfter(LocalDateTime.now());
        if (isInClosedDimension && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            String date = newDimension == Level.END ? String.valueOf(Config.INSTANCE.endOpenDate) : String.valueOf(Config.INSTANCE.netherOpenDate);
            TextUtils.sendMessage(player, Component.translatable((String)"message.lattice.dimension_closed").append((Component)Component.literal((String)date).withStyle(style -> style.withItalic(Boolean.valueOf(true)))));
            cir.setReturnValue(null);
        }
    }
}

