/*
 * Decompiled with CFR 0.152.
 */
package dev.lumentae.lattice;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.lumentae.lattice.Config;
import dev.lumentae.lattice.Constants;
import dev.lumentae.lattice.Mod;
import dev.lumentae.lattice.dispenser.DispenserBehavior;
import dev.lumentae.lattice.nickname.NicknameManager;
import dev.lumentae.lattice.packet.ServerboundModSharePacket;
import dev.lumentae.lattice.platform.Services;
import dev.lumentae.lattice.status.StatusManager;
import dev.lumentae.lattice.util.TextUtils;
import dev.lumentae.lattice.util.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_8828;
import net.minecraft.server.MinecraftServer;

public class Event {
    public static void OnServerStarted(MinecraftServer server) {
        Mod.setServer(server);
        class_3222 player = Services.PLATFORM.getFakePlayer(server);
        class_2357 behaviors = DispenserBehavior.getDispenserBehavior(player);
        class_7923.field_41178.forEach(item -> {
            if (class_2315.field_10919.containsKey(item)) {
                return;
            }
            class_2315.method_10009((class_1935)item, (class_2357)behaviors);
        });
    }

    public static void OnServerStopping(MinecraftServer server) {
        Mod.setServer(null);
        Config.saveConfig();
    }

    public static void OnRespawn(class_3222 player) {
        if (player.method_43122().isEmpty()) {
            return;
        }
        class_4208 o = (class_4208)player.method_43122().get();
        player.method_43496((class_2561)class_2561.method_43471((String)"message.lattice.death.1").method_27693(String.valueOf(o.comp_2208().method_10263())).method_27693(", ").method_27693(String.valueOf(o.comp_2208().method_10264())).method_27693(", ").method_27693(String.valueOf(o.comp_2208().method_10260())).method_10852((class_2561)class_2561.method_43471((String)"message.lattice.death.2")));
    }

    public static void OnJoin(class_3244 handler) {
        class_3222 player = handler.method_32311();
        Config.INSTANCE.playerOptions.computeIfAbsent(player.method_5667(), k -> Config.DEFAULT_PLAY_OPTIONS);
        if (Config.INSTANCE.serverOpenDate.after(new Date()) && !player.method_5687(2)) {
            class_5250 reason = class_2561.method_43471((String)"message.lattice.server.closed.1").method_10852((class_2561)class_2561.method_43471((String)"message.lattice.server.closed.2")).method_10852((class_2561)class_5250.method_43477((class_7417)new class_8828.class_2585(Config.INSTANCE.serverOpenDate.toString())).method_27694(style -> style.method_10977(class_124.field_1060))).method_27693("!");
            class_2661 packet = new class_2661((class_2561)reason);
            handler.method_14364((class_2596)packet);
        }
    }

    public static void OnCommandRegister(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"nv").executes(commandContext -> {
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            assert (player != null);
            if (player.method_6059(class_1294.field_5925)) {
                player.method_6016(class_1294.field_5925);
                return 1;
            }
            player.method_6092(new class_1293(class_1294.field_5925, -1, 255, false, false));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lattice").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("save");
            builder.suggest("reload");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String action = StringArgumentType.getString((CommandContext)commandContext, (String)"action");
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            assert (player != null);
            switch (action) {
                case "save": {
                    Config.saveConfig();
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.save"));
                    return 1;
                }
                case "reload": {
                    Config.loadConfig();
                    TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.reload"));
                    return 1;
                }
            }
            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.lattice.unknown").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)action)));
            return 0;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nick").then(class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            assert (player != null);
            builder.suggest(player.method_5477().getString());
            return builder.buildFuture();
        }).executes(commandContext -> {
            String nickname = StringArgumentType.getString((CommandContext)commandContext, (String)"nickname");
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            assert (player != null);
            if (nickname.equals(player.method_5477().getString())) {
                NicknameManager.removeNickname(player);
                TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.removed").method_27692(class_124.field_1060));
                return 1;
            }
            NicknameManager.setNickname(player, nickname);
            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.set").method_10852((class_2561)class_2561.method_43470((String)nickname).method_27692(class_124.field_1060)));
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            assert (player != null);
            String name = Config.INSTANCE.nicknames.get(player.method_5667());
            if (name == null) {
                TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.none").method_27692(class_124.field_1061));
            } else {
                TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.nickname.show").method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1060)));
            }
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"status").then(class_2170.method_9244((String)"status", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            builder.suggest("reset");
            return builder.buildFuture();
        }).executes(commandContext -> {
            String status = StringArgumentType.getString((CommandContext)commandContext, (String)"status");
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            assert (player != null);
            if (status.equals("reset")) {
                StatusManager.removeStatus(player);
                TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.removed").method_27692(class_124.field_1060));
                return 1;
            }
            StatusManager.setStatus(player, status);
            TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.set").method_10852(TextUtils.parseColoredText(status)));
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            assert (player != null);
            String status = Config.INSTANCE.status.get(player.method_5667());
            if (status == null) {
                TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.none").method_27692(class_124.field_1061));
            } else {
                TextUtils.sendMessage(player, class_2561.method_43471((String)"message.lattice.status.show").method_10852((class_2561)class_2561.method_43470((String)status)));
            }
            return 1;
        }));
    }

    public static void OnModSharePacket(ServerboundModSharePacket packet) {
        Constants.LOG.info("Received mod/resource pack list from server:");
        Constants.LOG.info("Origin: {} ({})", (Object)packet.origin(), (Object)Utils.getPlayerNameByUUID(UUID.fromString(packet.origin())));
        Constants.LOG.info("Mods: {}", (Object)packet.mods());
        Constants.LOG.info("Resource Packs: {}", (Object)packet.resourcePacks());
        if (Utils.containsIllegalMods(packet.mods()) || Utils.containsIllegalMods(packet.resourcePacks())) {
            Constants.LOG.warn("Illegal mods or resource packs!");
            ArrayList<String> illegalMods = new ArrayList<String>(packet.mods().replace('|', '\n').lines().filter(Utils::containsIllegalMods).toList());
            illegalMods.addAll(packet.resourcePacks().replace('|', '\n').lines().filter(Utils::containsIllegalMods).toList());
            class_3222 player = Utils.getPlayerByUUID(UUID.fromString(packet.origin()));
            if (player != null) {
                class_2661 kickPacket = new class_2661((class_2561)class_2561.method_43471((String)"message.lattice.illegal_mods").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"\n- ")).method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)"\n- ", illegalMods)).method_27692(class_124.field_1061)));
                player.field_13987.method_14364((class_2596)kickPacket);
                player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"message.lattice.illegal_mods").method_27692(class_124.field_1061));
            }
        }
    }
}

