/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.transport;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import me.playbosswar.com.commandtimer.sentry.DateUtils;
import me.playbosswar.com.commandtimer.sentry.Hint;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.RequestDetails;
import me.playbosswar.com.commandtimer.sentry.SentryDate;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelope;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.UncaughtExceptionHandlerIntegration;
import me.playbosswar.com.commandtimer.sentry.cache.IEnvelopeCache;
import me.playbosswar.com.commandtimer.sentry.clientreport.DiscardReason;
import me.playbosswar.com.commandtimer.sentry.hints.Cached;
import me.playbosswar.com.commandtimer.sentry.hints.DiskFlushNotification;
import me.playbosswar.com.commandtimer.sentry.hints.Enqueable;
import me.playbosswar.com.commandtimer.sentry.hints.Retryable;
import me.playbosswar.com.commandtimer.sentry.hints.SubmissionResult;
import me.playbosswar.com.commandtimer.sentry.transport.HttpConnection;
import me.playbosswar.com.commandtimer.sentry.transport.ITransport;
import me.playbosswar.com.commandtimer.sentry.transport.ITransportGate;
import me.playbosswar.com.commandtimer.sentry.transport.NoOpEnvelopeCache;
import me.playbosswar.com.commandtimer.sentry.transport.QueuedThreadPoolExecutor;
import me.playbosswar.com.commandtimer.sentry.transport.RateLimiter;
import me.playbosswar.com.commandtimer.sentry.transport.TransportResult;
import me.playbosswar.com.commandtimer.sentry.util.HintUtils;
import me.playbosswar.com.commandtimer.sentry.util.LogUtils;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class AsyncHttpTransport
implements ITransport {
    @NotNull
    private final QueuedThreadPoolExecutor executor;
    @NotNull
    private final IEnvelopeCache envelopeCache;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final ITransportGate transportGate;
    @NotNull
    private final HttpConnection connection;

    public AsyncHttpTransport(@NotNull SentryOptions options, @NotNull RateLimiter rateLimiter, @NotNull ITransportGate transportGate, @NotNull RequestDetails requestDetails) {
        this(AsyncHttpTransport.initExecutor(options.getMaxQueueSize(), options.getEnvelopeDiskCache(), options.getLogger()), options, rateLimiter, transportGate, new HttpConnection(options, requestDetails, rateLimiter));
    }

    public AsyncHttpTransport(@NotNull QueuedThreadPoolExecutor executor, @NotNull SentryOptions options, @NotNull RateLimiter rateLimiter, @NotNull ITransportGate transportGate, @NotNull HttpConnection httpConnection) {
        this.executor = Objects.requireNonNull(executor, "executor is required");
        this.envelopeCache = Objects.requireNonNull(options.getEnvelopeDiskCache(), "envelopeCache is required");
        this.options = Objects.requireNonNull(options, "options is required");
        this.rateLimiter = Objects.requireNonNull(rateLimiter, "rateLimiter is required");
        this.transportGate = Objects.requireNonNull(transportGate, "transportGate is required");
        this.connection = Objects.requireNonNull(httpConnection, "httpConnection is required");
    }

    @Override
    public void send(@NotNull SentryEnvelope envelope, @NotNull Hint hint) throws IOException {
        SentryEnvelope filteredEnvelope;
        IEnvelopeCache currentEnvelopeCache = this.envelopeCache;
        boolean cached = false;
        if (HintUtils.hasType(hint, Cached.class)) {
            currentEnvelopeCache = NoOpEnvelopeCache.getInstance();
            cached = true;
            this.options.getLogger().log(SentryLevel.DEBUG, "Captured Envelope is already cached", new Object[0]);
        }
        if ((filteredEnvelope = this.rateLimiter.filter(envelope, hint)) == null) {
            if (cached) {
                this.envelopeCache.discard(envelope);
            }
        } else {
            SentryEnvelope envelopeThatMayIncludeClientReport = HintUtils.hasType(hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class) ? this.options.getClientReportRecorder().attachReportToEnvelope(filteredEnvelope) : filteredEnvelope;
            Future<?> future = this.executor.submit(new EnvelopeSender(envelopeThatMayIncludeClientReport, hint, currentEnvelopeCache));
            if (future != null && future.isCancelled()) {
                this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.QUEUE_OVERFLOW, envelopeThatMayIncludeClientReport);
            } else {
                HintUtils.runIfHasType(hint, Enqueable.class, enqueable -> {
                    enqueable.markEnqueued();
                    this.options.getLogger().log(SentryLevel.DEBUG, "Envelope enqueued", new Object[0]);
                });
            }
        }
    }

    @Override
    public void flush(long timeoutMillis) {
        this.executor.waitTillIdle(timeoutMillis);
    }

    private static QueuedThreadPoolExecutor initExecutor(int maxQueueSize, @NotNull IEnvelopeCache envelopeCache, @NotNull ILogger logger) {
        RejectedExecutionHandler storeEvents = (r, executor) -> {
            if (r instanceof EnvelopeSender) {
                EnvelopeSender envelopeSender = (EnvelopeSender)r;
                if (!HintUtils.hasType(envelopeSender.hint, Cached.class)) {
                    envelopeCache.store(envelopeSender.envelope, envelopeSender.hint);
                }
                AsyncHttpTransport.markHintWhenSendingFailed(envelopeSender.hint, true);
                logger.log(SentryLevel.WARNING, "Envelope rejected", new Object[0]);
            }
        };
        return new QueuedThreadPoolExecutor(1, maxQueueSize, new AsyncConnectionThreadFactory(), storeEvents, logger);
    }

    @Override
    @NotNull
    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        this.options.getLogger().log(SentryLevel.DEBUG, "Shutting down", new Object[0]);
        try {
            if (!this.executor.awaitTermination(this.options.getFlushTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to shutdown the async connection async sender within 1 minute. Trying to force it now.", new Object[0]);
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Thread interrupted while closing the connection.", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    private static void markHintWhenSendingFailed(@NotNull Hint hint, boolean retry) {
        HintUtils.runIfHasType(hint, SubmissionResult.class, result -> result.setResult(false));
        HintUtils.runIfHasType(hint, Retryable.class, retryable -> retryable.setRetry(retry));
    }

    private final class EnvelopeSender
    implements Runnable {
        @NotNull
        private final SentryEnvelope envelope;
        @NotNull
        private final Hint hint;
        @NotNull
        private final IEnvelopeCache envelopeCache;
        private final TransportResult failedResult = TransportResult.error();

        EnvelopeSender(@NotNull SentryEnvelope envelope, @NotNull Hint hint, IEnvelopeCache envelopeCache) {
            this.envelope = Objects.requireNonNull(envelope, "Envelope is required.");
            this.hint = hint;
            this.envelopeCache = Objects.requireNonNull(envelopeCache, "EnvelopeCache is required.");
        }

        @Override
        public void run() {
            TransportResult result = this.failedResult;
            try {
                result = this.flush();
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Envelope flushed", new Object[0]);
            }
            catch (Throwable e) {
                AsyncHttpTransport.this.options.getLogger().log(SentryLevel.ERROR, e, "Envelope submission failed", new Object[0]);
                throw e;
            }
            finally {
                TransportResult finalResult = result;
                HintUtils.runIfHasType(this.hint, SubmissionResult.class, submissionResult -> {
                    AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Marking envelope submission result: %s", finalResult.isSuccess());
                    submissionResult.setResult(finalResult.isSuccess());
                });
            }
        }

        @NotNull
        private TransportResult flush() {
            TransportResult result = this.failedResult;
            this.envelope.getHeader().setSentAt(null);
            this.envelopeCache.store(this.envelope, this.hint);
            HintUtils.runIfHasType(this.hint, DiskFlushNotification.class, diskFlushNotification -> {
                if (diskFlushNotification.isFlushable(this.envelope.getHeader().getEventId())) {
                    diskFlushNotification.markFlushed();
                    AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Disk flush envelope fired", new Object[0]);
                } else {
                    AsyncHttpTransport.this.options.getLogger().log(SentryLevel.DEBUG, "Not firing envelope flush as there's an ongoing transaction", new Object[0]);
                }
            });
            if (AsyncHttpTransport.this.transportGate.isConnected()) {
                SentryEnvelope envelopeWithClientReport = AsyncHttpTransport.this.options.getClientReportRecorder().attachReportToEnvelope(this.envelope);
                try {
                    @NotNull SentryDate now = AsyncHttpTransport.this.options.getDateProvider().now();
                    envelopeWithClientReport.getHeader().setSentAt(DateUtils.nanosToDate(now.nanoTimestamp()));
                    result = AsyncHttpTransport.this.connection.send(envelopeWithClientReport);
                    if (!result.isSuccess()) {
                        String message = "The transport failed to send the envelope with response code " + result.getResponseCode();
                        AsyncHttpTransport.this.options.getLogger().log(SentryLevel.ERROR, message, new Object[0]);
                        if (result.getResponseCode() >= 400 && result.getResponseCode() != 429) {
                            HintUtils.runIfDoesNotHaveType(this.hint, Retryable.class, hint -> AsyncHttpTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, envelopeWithClientReport));
                        }
                        throw new IllegalStateException(message);
                    }
                    this.envelopeCache.discard(this.envelope);
                }
                catch (IOException e) {
                    HintUtils.runIfHasType(this.hint, Retryable.class, retryable -> retryable.setRetry(true), (hint, clazz) -> {
                        LogUtils.logNotInstanceOf(clazz, hint, AsyncHttpTransport.this.options.getLogger());
                        AsyncHttpTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, envelopeWithClientReport);
                    });
                    throw new IllegalStateException("Sending the event failed.", e);
                }
            } else {
                HintUtils.runIfHasType(this.hint, Retryable.class, retryable -> retryable.setRetry(true), (hint, clazz) -> {
                    LogUtils.logNotInstanceOf(clazz, hint, AsyncHttpTransport.this.options.getLogger());
                    AsyncHttpTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, this.envelope);
                });
            }
            return result;
        }
    }

    private static final class AsyncConnectionThreadFactory
    implements ThreadFactory {
        private int cnt;

        private AsyncConnectionThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread ret = new Thread(r, "SentryAsyncConnection-" + this.cnt++);
            ret.setDaemon(true);
            return ret;
        }
    }
}

