/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.conditions;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.util.ArrayList;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.conditionsengine.validations.Condition;
import me.playbosswar.com.conditionsengine.validations.ConditionType;
import me.playbosswar.com.conditionsengine.validations.SimpleCondition;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.conditions.ConditionMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ConditionsMenu
implements InventoryProvider {
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    public SmartInventory INVENTORY;
    private final Task task;
    private final Condition condition;
    private final Callback<?> onClose;

    public ConditionsMenu(Task task, Condition condition, Callback<?> onClose) {
        this.task = task;
        this.condition = condition;
        this.onClose = onClose;
        this.INVENTORY = SmartInventory.builder().id("condition-parts").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.CONDITION_PARTS_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        Callback<Object> internalCallback = data -> this.INVENTORY.open(player);
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems(this.getAllConditions(player));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        ItemStack createItem = Items.generateItem(LanguageKey.ADD_CONDITION, XMaterial.ANVIL);
        ClickableItem clickableCreate = ClickableItem.of(createItem, e -> {
            Condition newCondition = new Condition(ConditionType.SIMPLE, new ArrayList<Condition>(), new SimpleCondition());
            this.condition.addCondition(newCondition);
            this.task.storeInstance();
            new ConditionMenu((Task)this.task, (Condition)newCondition, internalCallback).INVENTORY.open(player);
        });
        contents.set(0, 0, clickableCreate);
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> this.onClose.execute(null)));
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }

    private ClickableItem[] getAllConditions(Player p) {
        Callback<Object> internalCallback = data -> this.INVENTORY.open(p);
        List conditions = this.condition.getConditions();
        if (conditions == null) {
            return new ClickableItem[0];
        }
        ClickableItem[] items = new ClickableItem[conditions.size()];
        for (int i = 0; i < items.length; ++i) {
            String[] lore;
            Condition condition = (Condition)conditions.get(i);
            ConditionType conditionType = condition.getConditionType();
            if (conditionType.equals((Object)ConditionType.OR) || conditionType.equals((Object)ConditionType.AND)) {
                lore = new String[]{"", this.languageManager.get(LanguageKey.TYPE, conditionType.toString()), "", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT), this.languageManager.get(LanguageKey.RIGHT_CLICK_DELETE)};
            } else {
                SimpleCondition simpleCondition = (SimpleCondition)condition.getSimpleCondition();
                String conditionGroup = simpleCondition.getConditionGroup();
                String rule = simpleCondition.getRule();
                lore = new String[]{"", this.languageManager.get(LanguageKey.TYPE, conditionType.toString()), "", this.languageManager.get(LanguageKey.CURRENT_CONFIGURATION), this.languageManager.get(LanguageKey.CONDITION_GROUP) + (conditionGroup == null ? this.languageManager.get(LanguageKey.NOT_SET) : "\u00a7e" + conditionGroup), this.languageManager.get(LanguageKey.CONDITION_RULE) + (rule == null ? this.languageManager.get(LanguageKey.NOT_SET) : "\u00a7e" + rule), "", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT), this.languageManager.get(LanguageKey.RIGHT_CLICK_DELETE)};
            }
            ItemStack item = Items.generateItem(this.languageManager.get(LanguageKey.CONDITION) + (i + 1), XMaterial.COMMAND_BLOCK, lore);
            items[i] = ClickableItem.of(item, e -> {
                if (e.getClick().equals((Object)ClickType.LEFT)) {
                    new ConditionMenu((Task)this.task, (Condition)condition, internalCallback).INVENTORY.open(p);
                    return;
                }
                if (e.getClick().equals((Object)ClickType.RIGHT)) {
                    this.condition.removeCondition(condition);
                    this.task.storeInstance();
                    this.INVENTORY.open(p);
                }
            });
        }
        return items;
    }
}

