/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.events;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.ConditionExtension;
import me.playbosswar.com.api.events.EventCondition;
import me.playbosswar.com.api.events.EventConfiguration;
import me.playbosswar.com.api.events.EventExtension;
import me.playbosswar.com.api.events.EventSimpleCondition;
import me.playbosswar.com.conditionsengine.validations.ConditionType;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.events.ConfigureEventMenu;
import me.playbosswar.com.gui.events.MainEventsMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SelectEventsMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final ConditionExtension extension;
    private final Task task;

    public SelectEventsMenu(Task task, ConditionExtension extension) {
        this.extension = extension;
        this.task = task;
        this.INVENTORY = SmartInventory.builder().id("edit-event").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.SELECT_EVENTS_GUI_TITLE).replace("$1", extension.getConditionGroupName())).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems((ClickableItem[])this.extension.getEvents().stream().map(event -> {
            Optional<EventConfiguration> existingConfiguration = this.task.getEvents().stream().filter(ev -> ev.getConditionGroup().equals(this.extension.getConditionGroupName()) && ev.getEvent().equals(event.getEventName())).findAny();
            List description = Arrays.stream(event.getEventDescription()).map(d -> "&7" + d).collect(Collectors.toList());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.addAll(description);
            lore.add("");
            if (existingConfiguration.isPresent() && existingConfiguration.get().isActive()) {
                lore.add(this.languageManager.get(LanguageKey.STATUS_ACTIVE));
            } else {
                lore.add(this.languageManager.get(LanguageKey.STATUS_NOT_ACTIVE));
            }
            lore.add("");
            lore.add(this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT));
            lore.add(this.languageManager.get(LanguageKey.RIGHT_CLICK_TOGGLE));
            ItemStack item = Items.generateItem("&b" + event.getEventName(), XMaterial.BEACON, lore.toArray(new String[0]));
            return ClickableItem.of(item, e -> {
                Callback<Object> internalCallback = data -> this.INVENTORY.open(player);
                if (e.isLeftClick()) {
                    if (existingConfiguration.isPresent()) {
                        new ConfigureEventMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)event, (EventCondition)((EventConfiguration)existingConfiguration.get()).getCondition(), internalCallback).INVENTORY.open(player);
                        return;
                    }
                    EventCondition condition = new EventCondition(ConditionType.SIMPLE, new EventSimpleCondition<String>("", ""), (List<EventCondition>)new ArrayList<EventCondition>());
                    EventConfiguration configuration = new EventConfiguration(true, this.extension.getConditionGroupName(), event.getEventName(), condition);
                    this.task.getEvents().add(configuration);
                    this.task.storeInstance();
                    new ConfigureEventMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)event, (EventCondition)condition, internalCallback).INVENTORY.open(player);
                }
                if (e.isRightClick()) {
                    EventConfiguration configuration;
                    if (existingConfiguration.isPresent()) {
                        configuration = (EventConfiguration)existingConfiguration.get();
                    } else {
                        EventCondition condition = new EventCondition(ConditionType.SIMPLE, new EventSimpleCondition<String>("", ""), (List<EventCondition>)new ArrayList<EventCondition>());
                        configuration = new EventConfiguration(true, this.extension.getConditionGroupName(), event.getEventName(), condition);
                    }
                    configuration.setActive(!configuration.isActive());
                    this.task.storeInstance();
                    this.INVENTORY.open(player);
                }
            });
        }).toArray(ClickableItem[]::new));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> new MainEventsMenu((Task)this.task).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

