/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.language;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.utils.Messages;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class LanguageManager {
    private final Plugin plugin;
    private final String selectedLanguage;
    private final Map<LanguageKey, String> translations = new HashMap<LanguageKey, String>();

    public LanguageManager(Plugin plugin) {
        this(plugin, "en");
    }

    public LanguageManager(Plugin plugin, String language) {
        this.plugin = plugin;
        this.selectedLanguage = language;
        try {
            this.validateConfiguration();
            this.loadLanguage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validateConfiguration() throws Exception {
        boolean fileSaveRequired = false;
        JSONObject selectedLanguageObject = this.getLanguageObject(this.selectedLanguage);
        JSONObject defaultLanguageObject = this.getLanguageObject("default");
        for (LanguageKey languageKey : LanguageKey.values()) {
            if (selectedLanguageObject.get((Object)languageKey.toString().toLowerCase()) != null) continue;
            Bukkit.getLogger().log(Level.WARNING, "Translation file " + this.selectedLanguage + " is missing the key " + languageKey.toString().toLowerCase() + ", adding default value");
            selectedLanguageObject.put((Object)languageKey.toString().toLowerCase(), defaultLanguageObject.get((Object)languageKey.toString().toLowerCase()));
            fileSaveRequired = true;
        }
        if (fileSaveRequired) {
            try {
                String filePath = this.getLanguageFilePath(this.selectedLanguage);
                FileWriter jsonFile = new FileWriter(filePath);
                jsonFile.write(selectedLanguageObject.toJSONString());
                jsonFile.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadLanguage() throws Exception {
        JSONObject obj = this.getLanguageObject(this.selectedLanguage);
        Arrays.stream(LanguageKey.values()).forEach(languageKey -> {
            boolean fileHasKey = obj.containsKey((Object)languageKey.toString().toLowerCase());
            if (!fileHasKey) {
                Bukkit.getPluginManager().disablePlugin(CommandTimerPlugin.getPlugin());
                throw new RuntimeException("Could not find translation for " + languageKey.toString().toLowerCase() + " for language " + this.selectedLanguage);
            }
            this.translations.put((LanguageKey)((Object)languageKey), (String)obj.get((Object)languageKey.toString().toLowerCase()));
        });
    }

    private JSONObject getLanguageObject(String language) throws IOException, ParseException {
        String fileName = this.getLanguageFilePath(language);
        JSONParser parser = new JSONParser();
        return (JSONObject)parser.parse((Reader)new FileReader(fileName));
    }

    private String getLanguageFilePath(String language) {
        return this.plugin.getDataFolder().getAbsolutePath() + "/languages/" + language + ".json";
    }

    public String get(LanguageKey key) {
        String text = this.translations.get((Object)key);
        if (text == null) {
            Bukkit.getLogger().log(Level.WARNING, "could not load key " + key.name());
            return "";
        }
        return Messages.colorize(text);
    }

    public String get(LanguageKey key, String ... replacers) {
        String translation = Messages.colorize(this.translations.get((Object)key));
        for (int i = 1; i <= replacers.length; ++i) {
            String placeholder = "$" + i;
            translation = translation.replace(placeholder, replacers[i - 1]);
        }
        return translation;
    }

    public ArrayList<String> getList(LanguageKey key, String ... replacers) {
        return new ArrayList<String>(Arrays.asList(this.get(key, replacers).split("\n")));
    }

    public ArrayList<String> getList(LanguageKey key) {
        return new ArrayList<String>(Arrays.asList(this.get(key).split("\n")));
    }
}

