/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class Updater {
    private static final String USER_AGENT = "Updater by Stipess1";
    private String downloadLink;
    private final Plugin plugin;
    private final int id = 24141;
    private int page = 1;
    private final UpdateType updateType = UpdateType.VERSION_CHECK;
    private Result result = Result.SUCCESS;
    private boolean emptyPage;
    private final Thread thread;
    private static final String DOWNLOAD = "/download";
    private static final String VERSIONS = "/versions";
    private static final String PAGE = "?page=";
    private static final String API_RESOURCE = "https://api.spiget.org/v2/resources/";

    public Updater(Plugin plugin) {
        this.plugin = plugin;
        this.downloadLink = "https://api.spiget.org/v2/resources/24141";
        this.thread = new Thread(new UpdaterRunnable());
        this.thread.start();
    }

    public Result getResult() {
        this.waitThread();
        return this.result;
    }

    private boolean checkResource(String link) {
        try {
            URL url = new URL(link);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            int code = connection.getResponseCode();
            if (code != 200) {
                connection.disconnect();
                this.result = Result.BAD_ID;
                return false;
            }
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void checkUpdate() {
        try {
            String page = Integer.toString(this.page);
            URL url = new URL("https://api.spiget.org/v2/resources/24141/versions?page=" + page);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            InputStream inputStream = connection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            JsonElement element = new JsonParser().parse((Reader)reader);
            JsonArray jsonArray = element.getAsJsonArray();
            if (jsonArray.size() == 10 && !this.emptyPage) {
                connection.disconnect();
                ++this.page;
                this.checkUpdate();
            } else if (jsonArray.size() == 0) {
                this.emptyPage = true;
                --this.page;
                this.checkUpdate();
            } else if (jsonArray.size() < 10) {
                element = jsonArray.get(jsonArray.size() - 1);
                JsonObject object = element.getAsJsonObject();
                element = object.get("name");
                String version = element.toString().replaceAll("\"", "").replace("v", "");
                boolean logger = true;
                if (logger) {
                    this.plugin.getLogger().info("Checking for update...");
                }
                if (this.shouldUpdate(version, this.plugin.getDescription().getVersion()) && this.updateType == UpdateType.VERSION_CHECK) {
                    this.result = Result.UPDATE_FOUND;
                    if (logger) {
                        this.plugin.getLogger().info("Update found!");
                    }
                } else {
                    if (logger) {
                        this.plugin.getLogger().info("Update not found");
                    }
                    this.result = Result.NO_UPDATE;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean shouldUpdate(String newVersion, String oldVersion) {
        return !newVersion.equalsIgnoreCase(oldVersion);
    }

    private void waitThread() {
        if (this.thread != null && this.thread.isAlive()) {
            this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> {
                try {
                    this.plugin.getLogger().log(Level.INFO, "Waiting for updater thread to finish.");
                    this.thread.join();
                    this.plugin.getLogger().log(Level.INFO, "Update done.");
                }
                catch (InterruptedException e) {
                    this.plugin.getLogger().log(Level.SEVERE, null, e);
                }
            });
        }
    }

    public class UpdaterRunnable
    implements Runnable {
        @Override
        public void run() {
            if (Updater.this.checkResource(Updater.this.downloadLink)) {
                Updater.this.downloadLink = Updater.this.downloadLink + Updater.DOWNLOAD;
                Updater.this.checkUpdate();
            }
        }
    }

    public static enum Result {
        UPDATE_FOUND,
        NO_UPDATE,
        SUCCESS,
        BAD_ID;

    }

    public static enum UpdateType {
        VERSION_CHECK;

    }
}

