/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import me.playbosswar.com.commandtimer.sentry.ISentryExecutorService;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryExecutorService
implements ISentryExecutorService {
    @NotNull
    private final ScheduledExecutorService executorService;

    @TestOnly
    SentryExecutorService(@NotNull ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public SentryExecutorService() {
        this(Executors.newSingleThreadScheduledExecutor(new SentryExecutorServiceThreadFactory()));
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable runnable) {
        return this.executorService.submit(runnable);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> callable) {
        return this.executorService.submit(callable);
    }

    @Override
    @NotNull
    public Future<?> schedule(@NotNull Runnable runnable, long delayMillis) {
        return this.executorService.schedule(runnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long timeoutMillis) {
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            return this.executorService.isShutdown();
        }
    }

    private static final class SentryExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        private SentryExecutorServiceThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread ret = new Thread(r, "SentryExecutorServiceThreadFactory-" + this.cnt++);
            ret.setDaemon(true);
            return ret;
        }
    }
}

