/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.events;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.util.ArrayList;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.ConditionExtension;
import me.playbosswar.com.api.events.EventCondition;
import me.playbosswar.com.api.events.EventExtension;
import me.playbosswar.com.api.events.EventSimpleCondition;
import me.playbosswar.com.conditionsengine.ConditionCompare;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.TextInputManager;
import me.playbosswar.com.gui.events.ConfigureEventMenu;
import me.playbosswar.com.gui.worlds.WorldSelector;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.ArrayUtils;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConfigureEventValuesMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final ConditionExtension extension;
    private final EventCondition condition;
    private final Task task;
    private final EventExtension eventExtension;
    private final Callback<?> callback;

    public ConfigureEventValuesMenu(Task task, ConditionExtension extension, EventExtension eventExtension, EventCondition condition, Callback<?> callback) {
        this.extension = extension;
        this.task = task;
        this.condition = condition;
        this.eventExtension = eventExtension;
        this.callback = callback;
        this.INVENTORY = SmartInventory.builder().id("configure-event-values").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.CONFIGURE_EVENT_VALUES_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems((ClickableItem[])this.eventExtension.getReturnedValues().stream().map(v -> {
            boolean isActiveValue = ((EventSimpleCondition)this.condition.getSimpleCondition()).getFieldName().equals(v.getName());
            String[] lore = isActiveValue ? new String[]{"", "&7Value: &e" + ((EventSimpleCondition)this.condition.getSimpleCondition()).getValue().toString(), "&7Condition: &e" + ((EventSimpleCondition)this.condition.getSimpleCondition()).getCompare().name()} : new String[]{"", "&7CLICK TO ACTIVATE"};
            ItemStack item = Items.generateItem("&b" + v.getLabel(), isActiveValue ? XMaterial.LIME_DYE : XMaterial.GRAY_DYE, lore);
            return ClickableItem.of(item, e -> {
                if (e.isLeftClick()) {
                    if (v.getType() == Double.class) {
                        player.closeInventory();
                        TextInputManager.getInstance().startTextInput(player, LanguageKey.TEXT_INPUT_DEFAULT, data -> {
                            double text = Double.parseDouble(data);
                            EventSimpleCondition<Double> simpleCondition = new EventSimpleCondition<Double>(v.getName(), text, ConditionCompare.EQUAL);
                            this.condition.setSimpleCondition(simpleCondition);
                            this.task.storeInstance();
                            new ConfigureEventValuesMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, this.callback).INVENTORY.open(player);
                        });
                        return;
                    }
                    if (v.getType() == Integer.class) {
                        player.closeInventory();
                        TextInputManager.getInstance().startTextInput(player, LanguageKey.TEXT_INPUT_DEFAULT, data -> {
                            int text = Integer.parseInt(data);
                            EventSimpleCondition<Integer> simpleCondition = new EventSimpleCondition<Integer>(v.getName(), text, ConditionCompare.EQUAL);
                            this.condition.setSimpleCondition(simpleCondition);
                            this.task.storeInstance();
                            new ConfigureEventValuesMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, this.callback).INVENTORY.open(player);
                        });
                        return;
                    }
                    if (v.getType() == String.class) {
                        player.closeInventory();
                        TextInputManager.getInstance().startTextInput(player, LanguageKey.TEXT_INPUT_DEFAULT, text -> {
                            EventSimpleCondition<String> simpleCondition = new EventSimpleCondition<String>(v.getName(), (String)text, ConditionCompare.EQUAL);
                            this.condition.setSimpleCondition(simpleCondition);
                            this.task.storeInstance();
                            new ConfigureEventValuesMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, this.callback).INVENTORY.open(player);
                        });
                    }
                    if (v.getType() == World.class) {
                        Callback<List<String>> worldCallback = worlds -> {
                            EventSimpleCondition simpleCondition = new EventSimpleCondition(v.getName(), worlds.get(0), ConditionCompare.EQUAL);
                            this.condition.setSimpleCondition(simpleCondition);
                            this.task.storeInstance();
                            new ConfigureEventValuesMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, this.callback).INVENTORY.open(player);
                        };
                        ArrayList<String> worlds2 = new ArrayList<String>();
                        worlds2.add(((EventSimpleCondition)this.condition.getSimpleCondition()).getValue().toString());
                        new WorldSelector(worldCallback, worlds2, (boolean)false).INVENTORY.open(player);
                    }
                }
                if (e.isRightClick()) {
                    ConditionCompare nextConditionCompare = ArrayUtils.getNextValueInArray(ConditionCompare.values(), ((EventSimpleCondition)this.condition.getSimpleCondition()).getCompare());
                    ((EventSimpleCondition)this.condition.getSimpleCondition()).setCompare(nextConditionCompare);
                    new ConfigureEventValuesMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, this.callback).INVENTORY.open(player);
                }
            });
        }).toArray(ClickableItem[]::new));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> new ConfigureEventMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, this.callback).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

