/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.MainMenu;
import me.playbosswar.com.gui.tasks.EditTaskMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.AdHocCommand;
import me.playbosswar.com.tasks.ScheduledTask;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import me.playbosswar.com.utils.Messages;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ScheduledExecutionsMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private FilterType filterType = FilterType.ALL;

    public ScheduledExecutionsMenu() {
        this.INVENTORY = SmartInventory.builder().id("scheduled-executions").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.SCHEDULED_EXECUTIONS_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems(this.getAllScheduledExecutionItems(player));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        ItemStack refreshItem = Items.generateItem(LanguageKey.REFRESH_BUTTON_TITLE, XMaterial.REPEATER, this.languageManager.getList(LanguageKey.REFRESH_BUTTON_LORE).toArray(new String[0]));
        contents.set(0, 8, ClickableItem.of(refreshItem, e -> {
            player.closeInventory();
            ScheduledExecutionsMenu newMenu = new ScheduledExecutionsMenu();
            newMenu.filterType = this.filterType;
            newMenu.INVENTORY.open(player);
        }));
        String allLabel = this.languageManager.get(LanguageKey.FILTER_ALL);
        String tasksLabel = this.languageManager.get(LanguageKey.FILTER_TASKS_ONLY);
        String adhocLabel = this.languageManager.get(LanguageKey.FILTER_ADHOC_ONLY);
        String[] filterLore = new String[]{this.filterType == FilterType.ALL ? "\u00a7f\u00bb " + allLabel + " \u00a7f\u00ab" : "\u00a78  " + allLabel, this.filterType == FilterType.TASKS_ONLY ? "\u00a7f\u00bb " + tasksLabel + " \u00a7f\u00ab" : "\u00a78  " + tasksLabel, this.filterType == FilterType.ADHOC_ONLY ? "\u00a7f\u00bb " + adhocLabel + " \u00a7f\u00ab" : "\u00a78  " + adhocLabel, "", "\u00a77Click to cycle"};
        ItemStack filterItem = Items.generateItem(LanguageKey.FILTER_BUTTON_TITLE, XMaterial.HOPPER, filterLore);
        contents.set(0, 0, ClickableItem.of(filterItem, e -> {
            this.filterType = this.filterType == FilterType.ALL ? FilterType.TASKS_ONLY : (this.filterType == FilterType.TASKS_ONLY ? FilterType.ADHOC_ONLY : FilterType.ALL);
            pagination.setItems(this.getAllScheduledExecutionItems(player));
            this.INVENTORY.open(player, 0);
        }));
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> new MainMenu().INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    /*
     * WARNING - void declaration
     */
    private ClickableItem[] getAllScheduledExecutionItems(Player p) {
        void var7_11;
        FilterType currentFilter = this.filterType;
        List<Object> scheduledTasks = new ArrayList();
        if (currentFilter == FilterType.ALL || currentFilter == FilterType.TASKS_ONLY) {
            scheduledTasks = CommandTimerPlugin.getInstance().getTasksManager().getScheduledTasks().stream().filter(scheduledTask -> scheduledTask.getDate().toInstant().toEpochMilli() >= System.currentTimeMillis()).collect(Collectors.toList());
        }
        List<Object> adHocCommands = new ArrayList();
        if (currentFilter == FilterType.ALL || currentFilter == FilterType.ADHOC_ONLY) {
            adHocCommands = CommandTimerPlugin.getInstance().getAdHocCommandsManager().getPendingCommands().stream().filter(cmd -> cmd.getScheduledTime().toInstant().toEpochMilli() >= System.currentTimeMillis()).collect(Collectors.toList());
        }
        ArrayList<ExecutionItem> allItems = new ArrayList<ExecutionItem>();
        for (ScheduledTask scheduledTask2 : scheduledTasks) {
            allItems.add(new ExecutionItem(scheduledTask2.getDate(), scheduledTask2, null));
        }
        for (AdHocCommand adHocCommand : adHocCommands) {
            allItems.add(new ExecutionItem(adHocCommand.getScheduledTime(), null, adHocCommand));
        }
        allItems.sort(Comparator.comparing(item -> item.date));
        ClickableItem[] items = new ClickableItem[allItems.size()];
        boolean bl = false;
        while (var7_11 < items.length) {
            String[] lore;
            ExecutionItem executionItem = (ExecutionItem)allItems.get((int)var7_11);
            ZonedDateTime date = executionItem.date;
            String formattedDate = date.format(DATE_FORMATTER);
            if (executionItem.scheduledTask != null) {
                lore = new String[]{"\u00a77Task: \u00a7e" + executionItem.scheduledTask.getTask().getName(), "\u00a77Scheduled: \u00a7e" + formattedDate, "", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT)};
                ItemStack item2 = Items.generateItem("\u00a7b" + executionItem.scheduledTask.getTask().getName(), XMaterial.CLOCK, lore);
                items[var7_11] = ClickableItem.of(item2, e -> {
                    Callback<Object> callback = data -> this.INVENTORY.open(p);
                    new EditTaskMenu((Task)executionItem.scheduledTask.getTask(), callback).INVENTORY.open(p);
                });
            } else if (executionItem.adHocCommand != null) {
                lore = new String[]{"\u00a77Command: \u00a7e" + executionItem.adHocCommand.getCommand(), "\u00a77Gender: \u00a7e" + executionItem.adHocCommand.getGender().name(), "\u00a77Scheduled: \u00a7e" + formattedDate, "", this.languageManager.get(LanguageKey.RIGHT_CLICK_DELETE)};
                ItemStack item2 = Items.generateItem("\u00a7bAd-Hoc Command", XMaterial.COMMAND_BLOCK, lore);
                AdHocCommand adHocCmd = executionItem.adHocCommand;
                items[var7_11] = ClickableItem.of(item2, e -> {
                    if (e.getClick().equals((Object)ClickType.RIGHT)) {
                        try {
                            CommandTimerPlugin.getInstance().getAdHocCommandsManager().removeCommand(adHocCmd);
                            p.closeInventory();
                            ScheduledExecutionsMenu newMenu = new ScheduledExecutionsMenu();
                            newMenu.filterType = currentFilter;
                            newMenu.INVENTORY.open(p);
                        }
                        catch (IOException ioException) {
                            Messages.sendFailedIO(p);
                            ioException.printStackTrace();
                        }
                    }
                });
            }
            ++var7_11;
        }
        return items;
    }

    private static class ExecutionItem {
        final ZonedDateTime date;
        final ScheduledTask scheduledTask;
        final AdHocCommand adHocCommand;

        ExecutionItem(ZonedDateTime date, ScheduledTask scheduledTask, AdHocCommand adHocCommand) {
            this.date = date;
            this.scheduledTask = scheduledTask;
            this.adHocCommand = adHocCommand;
        }
    }

    private static enum FilterType {
        ALL,
        TASKS_ONLY,
        ADHOC_ONLY;

    }
}

