/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.tasks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.enums.Gender;
import me.playbosswar.com.tasks.AdHocCommand;
import me.playbosswar.com.tasks.AdHocCommandRunner;
import me.playbosswar.com.utils.CommandExecutor;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.gson.GsonConverter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AdHocCommandsManager {
    private List<AdHocCommand> loadedCommands = new ArrayList<AdHocCommand>();
    private Thread runnerThread;
    public boolean stopRunner = false;

    public AdHocCommandsManager(Plugin plugin) {
        this.loadedCommands.addAll(this.loadAdHocCommandsFromFiles());
        this.startRunner();
    }

    public AdHocCommand scheduleCommand(String command, Gender gender, ZonedDateTime scheduledTime) {
        AdHocCommand adHocCommand = new AdHocCommand(command, gender, scheduledTime);
        this.loadedCommands.add(adHocCommand);
        this.storeCommand(adHocCommand);
        return adHocCommand;
    }

    @Nullable
    public AdHocCommand getCommandById(UUID id) {
        return this.loadedCommands.stream().filter(cmd -> cmd.getId().equals(id)).findFirst().orElse(null);
    }

    public void removeCommand(AdHocCommand command) throws IOException {
        this.loadedCommands.remove(command);
        Files.deleteIfExists(Paths.get(me.playbosswar.com.utils.Files.getAdHocCommandFile(command.getId()), new String[0]));
    }

    public List<AdHocCommand> getLoadedCommands() {
        return this.loadedCommands;
    }

    public List<AdHocCommand> getPendingCommands() {
        return this.loadedCommands.stream().filter(cmd -> !cmd.isExecuted()).collect(Collectors.toList());
    }

    private void startRunner() {
        AdHocCommandRunner runner = new AdHocCommandRunner(this);
        Thread thread = new Thread(runner);
        thread.start();
        this.runnerThread = thread;
    }

    public List<AdHocCommand> getCommandsToExecute() {
        ZonedDateTime now = ZonedDateTime.now();
        return this.loadedCommands.stream().filter(cmd -> !cmd.isExecuted() && cmd.getScheduledTime().toInstant().toEpochMilli() <= now.toInstant().toEpochMilli()).collect(Collectors.toList());
    }

    public void processCommandExecution(AdHocCommand adHocCommand) {
        CommandTimerPlugin.getScheduler().runTaskAsynchronously(() -> {
            CommandExecutor.ExecutionContext context = new CommandExecutor.ExecutionContext.Builder().command(adHocCommand.getCommand()).gender(adHocCommand.getGender()).build();
            CommandExecutor.execute(context);
            adHocCommand.setExecuted(true);
            this.storeCommand(adHocCommand);
        });
    }

    private List<AdHocCommand> loadAdHocCommandsFromFiles() {
        ArrayList<AdHocCommand> commands = new ArrayList<AdHocCommand>();
        File dir = new File(me.playbosswar.com.utils.Files.getAdHocCommandsDirectory());
        if (!dir.exists()) {
            dir.mkdirs();
            return commands;
        }
        File[] directoryListing = dir.listFiles(file -> file.getName().endsWith(".json"));
        JSONParser jsonParser = new JSONParser();
        GsonConverter gson = new GsonConverter();
        if (directoryListing != null) {
            for (File file2 : directoryListing) {
                try {
                    FileReader fr = new FileReader(file2.getPath());
                    AdHocCommand command = (AdHocCommand)gson.fromJson(jsonParser.parse((Reader)fr).toString(), (Type)((Object)AdHocCommand.class));
                    if (command == null || command.isExecuted()) continue;
                    commands.add(command);
                }
                catch (IOException | ParseException e) {
                    Messages.sendConsole("Failed to load ad-hoc command from " + file2.getName() + ": " + e.getMessage());
                }
            }
        }
        return commands;
    }

    private void storeCommand(AdHocCommand command) {
        GsonConverter gson = new GsonConverter();
        String json = gson.toJson(command);
        try {
            FileWriter jsonFile = new FileWriter(me.playbosswar.com.utils.Files.getAdHocCommandFile(command.getId()));
            jsonFile.write(json);
            jsonFile.flush();
            jsonFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void disable() {
        this.stopRunner = true;
        if (this.runnerThread != null && this.runnerThread.isAlive()) {
            this.runnerThread.interrupt();
        }
    }
}

