/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.tasks;

import java.util.ArrayList;
import java.util.TimerTask;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.Sentry;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.tasks.CommandIntervalExecutorRunnable;
import me.playbosswar.com.tasks.ScheduledTask;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TasksManager;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.Tools;

public class TaskRunner
implements Runnable {
    private final TasksManager tasksManager;

    public TaskRunner(TasksManager tasksManager) {
        this.tasksManager = tasksManager;
    }

    private void processTask(Task task) {
        if (this.tasksManager.stopRunner) {
            return;
        }
        Messages.sendDebugConsole("Checking if " + task.getName() + " can be executed");
        if (!Tools.randomCheck(task.getRandom())) {
            Messages.sendDebugConsole("Task has a random execution chance");
            return;
        }
        CommandExecutionMode executionMode = task.getCommandExecutionMode();
        if (executionMode.equals((Object)CommandExecutionMode.INTERVAL)) {
            CommandTimerPlugin.getScheduler().runTaskTimer(new CommandIntervalExecutorRunnable(task), 1L, (long)task.getCommandExecutionInterval().toSeconds() * 20L);
            return;
        }
        boolean hasDelayedCommands = task.getCommands().stream().anyMatch(c -> c.getDelay().toSeconds() > 0);
        if (executionMode.equals((Object)CommandExecutionMode.ORDERED) && hasDelayedCommands) {
            int[] accumulatedDelaySeconds = new int[]{0};
            task.getCommands().forEach(command -> {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> this.tasksManager.processCommandExecution(task, (TaskCommand)command), 20L * (long)accumulatedDelaySeconds[0] + 1L);
                accumulatedDelaySeconds[0] = accumulatedDelaySeconds[0] + command.getDelay().toSeconds();
            });
            return;
        }
        int selectedCommandIndex = this.tasksManager.getNextTaskCommandIndex(task);
        if (selectedCommandIndex == -1) {
            task.setLastExecutedCommandIndex(0);
            CommandTimerPlugin.getScheduler().runTask(() -> task.getCommands().forEach(command -> this.tasksManager.processCommandExecution(task, (TaskCommand)command)));
        } else {
            TaskCommand taskCommand = task.getCommands().get(selectedCommandIndex);
            task.setLastExecutedCommandIndex(task.getCommands().indexOf(taskCommand));
            CommandTimerPlugin.getScheduler().runTask(() -> this.tasksManager.processCommandExecution(task, taskCommand));
        }
        task.storeInstance();
    }

    @Override
    public void run() {
        CommandTimerPlugin.getScheduler().runTaskTimer(new TimerTask(){

            @Override
            public void run() {
                if (((TaskRunner)TaskRunner.this).tasksManager.stopRunner) {
                    Messages.sendDebugConsole("Ignoring execution because manager has been stopped");
                    return;
                }
                ArrayList<ScheduledTask> tasksToExecute = new ArrayList<ScheduledTask>();
                Boolean exit = false;
                while (!exit.booleanValue()) {
                    ScheduledTask scheduledTask2 = TaskRunner.this.tasksManager.getScheduledTasks().peek();
                    if (scheduledTask2 == null) {
                        exit = true;
                        continue;
                    }
                    if (scheduledTask2.getDate().toInstant().toEpochMilli() > System.currentTimeMillis()) {
                        exit = true;
                        continue;
                    }
                    tasksToExecute.add(TaskRunner.this.tasksManager.getScheduledTasks().poll());
                }
                tasksToExecute.forEach(scheduledTask -> {
                    ITransaction transaction = Sentry.startTransaction("processTask()", "task");
                    TaskRunner.this.processTask(scheduledTask.getTask());
                    transaction.finish();
                });
            }
        }, 1L, 10L);
    }
}

