/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.events.EventConfiguration;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.Sentry;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskExecutionMetadata;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.gson.GsonConverter;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Files {
    static String pluginFolderPath = CommandTimerPlugin.getPlugin().getDataFolder().getPath();

    public static void createDataFolders() {
        File timersFile = new File(pluginFolderPath + "/timers");
        File extensionsFolder = new File(pluginFolderPath + "/extensions");
        File adHocCommandsFolder = new File(pluginFolderPath + "/ad-hoc-commands");
        timersFile.mkdirs();
        extensionsFolder.mkdirs();
        adHocCommandsFolder.mkdirs();
        File dataFolder = CommandTimerPlugin.getPlugin().getDataFolder();
        File enLangFile = new File(dataFolder.getAbsoluteFile() + "/languages/en.json");
        if (!enLangFile.exists()) {
            Messages.sendDebugConsole("could not find languages/en.json, creating default");
            CommandTimerPlugin.getPlugin().saveResource("languages/en.json", false);
        }
        CommandTimerPlugin.getPlugin().saveResource("languages/default.json", true);
    }

    public static String getTaskFile(UUID id) {
        return pluginFolderPath + "/timers/" + id + ".json";
    }

    public static String getTaskLocalExecutionFile(UUID id) {
        return pluginFolderPath + "/timers/" + id + ".local.json";
    }

    public static String getAdHocCommandsDirectory() {
        return pluginFolderPath + "/ad-hoc-commands";
    }

    public static String getAdHocCommandFile(UUID id) {
        return pluginFolderPath + "/ad-hoc-commands/" + id + ".json";
    }

    private static void healTask(Task task) {
        TaskInterval defaultInterval = new TaskInterval(0, 0, 0, 5);
        if (task.getCommands() == null) {
            task.setCommands(new ArrayList<TaskCommand>());
        }
        if (task.getInterval() == null) {
            task.setInterval(defaultInterval);
        }
        if (task.getTimes() == null) {
            task.setTimes(new ArrayList<TaskTime>());
        }
        if (task.getCommandExecutionInterval() == null) {
            task.setCommandExecutionInterval(defaultInterval);
        }
    }

    public static void migrateFileNamesToFileUuids() {
        File dir = new File(pluginFolderPath + "/timers");
        File[] directoryListing = dir.listFiles(file -> !file.getName().contains(".local.json"));
        if (directoryListing != null) {
            for (File file2 : directoryListing) {
                if (!file2.exists() || !file2.getName().contains("json")) continue;
                try {
                    UUID.fromString(file2.getName().replace(".json", ""));
                }
                catch (IllegalArgumentException e) {
                    try {
                        UUID uuid = UUID.randomUUID();
                        FileReader fr = new FileReader(file2.getPath());
                        JSONParser jsonParser = new JSONParser();
                        Task task = (Task)new GsonConverter().fromJson(jsonParser.parse((Reader)fr).toString(), (Type)((Object)Task.class));
                        task.setId(uuid);
                        GsonConverter gson = new GsonConverter();
                        String json = gson.toJson(task);
                        FileWriter jsonFile = new FileWriter(pluginFolderPath + "/timers/" + uuid + ".json");
                        jsonFile.write(json);
                        jsonFile.flush();
                        file2.delete();
                        Messages.sendConsole("Migrated " + file2.getName() + " to " + uuid + ".json");
                    }
                    catch (IOException | ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    public static TaskExecutionMetadata getOrCreateTaskMetadata(Task task) {
        try {
            String path = Files.getTaskLocalExecutionFile(task.getId());
            File file = new File(path);
            if (!file.exists()) {
                TaskExecutionMetadata metadata = new TaskExecutionMetadata(task.getTimesExecuted(), task.getLastExecutedCommandIndex(), task.getLastExecuted());
                GsonConverter gson = new GsonConverter();
                String json = gson.toJson(metadata);
                FileWriter jsonFile = new FileWriter(path);
                jsonFile.write(json);
                jsonFile.flush();
                return metadata;
            }
            FileReader fr = new FileReader(Files.getTaskLocalExecutionFile(task.getId()));
            JSONParser jsonParser = new JSONParser();
            TaskExecutionMetadata metadata = (TaskExecutionMetadata)new GsonConverter().fromJson(jsonParser.parse((Reader)fr).toString(), (Type)((Object)TaskExecutionMetadata.class));
            return metadata;
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateLocalTaskMetadata(Task task) {
        TaskExecutionMetadata metadata = new TaskExecutionMetadata(task.getTimesExecuted(), task.getLastExecutedCommandIndex(), task.getLastExecuted());
        GsonConverter gson = new GsonConverter();
        String json = gson.toJson(metadata);
        try {
            FileWriter jsonFile = new FileWriter(Files.getTaskLocalExecutionFile(task.getId()));
            jsonFile.write(json);
            jsonFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Task> deserializeJsonFilesIntoCommandTimers() {
        ITransaction transaction = Sentry.startTransaction("deserializeJsonFilesIntoCommandTimers()", "initiation");
        File dir = new File(pluginFolderPath + "/timers");
        File[] directoryListing = dir.listFiles(file -> !file.getName().contains(".local.json"));
        JSONParser jsonParser = new JSONParser();
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            if (directoryListing != null) {
                for (File file2 : directoryListing) {
                    if (!file2.exists() || !file2.getName().contains("json")) continue;
                    try {
                        Messages.sendConsole("Processing task " + file2.getName());
                        FileReader fr = new FileReader(file2.getPath());
                        GsonConverter gson = new GsonConverter();
                        Task task = (Task)gson.fromJson(jsonParser.parse((Reader)fr).toString(), (Type)((Object)Task.class));
                        Files.healTask(task);
                        task.getCommands().forEach(command -> {
                            if (command.getInterval() == null) {
                                command.setInterval(new TaskInterval(0, 0, 0, 0));
                            }
                            if (command.getDelay() == null) {
                                command.setDelay(new TaskInterval(0, 0, 0, 0));
                            }
                        });
                        if (task.getEvents() == null) {
                            task.setEvents(new ArrayList<EventConfiguration>());
                        }
                        tasks.add(task);
                    }
                    catch (JsonParseException e) {
                        Bukkit.getLogger().log(Level.SEVERE, "Failed to process " + file2.getName() + " because of " + e.getMessage());
                    }
                    catch (ParseException e) {
                        Bukkit.getLogger().log(Level.SEVERE, "Failed to process " + file2.getName() + " because of " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            transaction.setThrowable(e);
        }
        finally {
            transaction.finish();
        }
        return tasks;
    }

    @Nullable
    public static <T> Class<? extends T> findClass(@NotNull File file, @NotNull Class<T> clazz) throws IOException, ClassNotFoundException {
        if (!file.exists()) {
            return null;
        }
        URL jar = file.toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{jar}, clazz.getClassLoader());
        ArrayList<String> matches = new ArrayList<String>();
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        try (JarInputStream stream = new JarInputStream(jar.openStream());){
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                matches.add(name.substring(0, name.lastIndexOf(46)).replace('/', '.'));
            }
            for (String match : matches) {
                try {
                    Class<?> loaded = loader.loadClass(match);
                    if (!clazz.isAssignableFrom(loaded)) continue;
                    classes.add(loaded.asSubclass(clazz));
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
        if (classes.isEmpty()) {
            loader.close();
            return null;
        }
        return (Class)classes.get(0);
    }
}

