/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.language.LanguageKey;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Messages {
    private static final boolean debug = CommandTimerPlugin.getPlugin().getConfig().getBoolean("debug");

    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private static String getPrefix() {
        return CommandTimerPlugin.getLanguageManager().get(LanguageKey.PREFIX);
    }

    public static void sendMessageToPlayer(Player player, String message) {
        player.sendMessage(Messages.colorize(Messages.getPrefix() + message));
    }

    public static void sendConsole(String message) {
        Bukkit.getConsoleSender().sendMessage(Messages.colorize(Messages.getPrefix() + message));
    }

    public static void sendDebugConsole(String message) {
        if (debug) {
            Messages.sendConsole(message);
        }
    }

    public static void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(Messages.colorize(Messages.getPrefix() + message));
    }

    public static void sendMessage(CommandSender sender, LanguageKey key) {
        String message = CommandTimerPlugin.getLanguageManager().get(key);
        sender.sendMessage(Messages.colorize(Messages.getPrefix() + message));
    }

    public static void sendNeedToBePlayer(CommandSender sender) {
        sender.sendMessage(Messages.colorize(Messages.getPrefix() + CommandTimerPlugin.getLanguageManager().get(LanguageKey.NO_CONSOLE)));
    }

    public static void sendNoPermission(Player player) {
        player.sendMessage(Messages.colorize(Messages.getPrefix() + CommandTimerPlugin.getLanguageManager().get(LanguageKey.NO_PERMISSION)));
    }

    public static void sendNoPermission(CommandSender sender) {
        sender.sendMessage(Messages.colorize(Messages.getPrefix() + CommandTimerPlugin.getLanguageManager().get(LanguageKey.NO_PERMISSION)));
    }

    public static void sendFailedIO(Player player) {
        Messages.sendMessageToPlayer(player, CommandTimerPlugin.getLanguageManager().get(LanguageKey.IO_ERROR));
    }

    public static void sendHelpMessage(CommandSender sender) {
        Messages.sendMessage(sender, "\u00a77--- \u00a7eCommandTimer Help \u00a77---");
        Messages.sendMessage(sender, "\u00a7e/cmt help - \u00a77Open help menu");
        Messages.sendMessage(sender, "\u00a7e/cmt activate <task> - \u00a77Activate a task");
        Messages.sendMessage(sender, "\u00a7e/cmt deactivate <task> - \u00a77Deactivate a task");
        Messages.sendMessage(sender, "\u00a7e/cmt execute <task> - \u00a77Instantly execute a task");
        Messages.sendMessage(sender, "\u00a7e/cmt nextexecutions <task> - \u00a77Show next 10 executions for a task");
        Messages.sendMessage(sender, "\u00a7e/cmt schedule [-after 1h10m5s] [-gender CONSOLE] <command> - \u00a77Schedule a one-time command");
        Messages.sendMessage(sender, "\u00a7e/cmt reload - \u00a77Reload the plugin");
        Messages.sendMessage(sender, "\u00a7e/cmt migrateToDatabase - \u00a77Migrate JSON files to database");
    }
}

