/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.io.IOException;
import java.util.ArrayList;
import me.playbosswar.com.commandtimer.sentry.ISerializer;
import me.playbosswar.com.commandtimer.sentry.ProfilingTraceData;
import me.playbosswar.com.commandtimer.sentry.SentryBaseEvent;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelopeHeader;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelopeItem;
import me.playbosswar.com.commandtimer.sentry.Session;
import me.playbosswar.com.commandtimer.sentry.exception.SentryEnvelopeException;
import me.playbosswar.com.commandtimer.sentry.protocol.SdkVersion;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryId;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelope {
    @NotNull
    private final SentryEnvelopeHeader header;
    @NotNull
    private final Iterable<SentryEnvelopeItem> items;

    @NotNull
    public Iterable<SentryEnvelopeItem> getItems() {
        return this.items;
    }

    @NotNull
    public SentryEnvelopeHeader getHeader() {
        return this.header;
    }

    public SentryEnvelope(@NotNull SentryEnvelopeHeader header, @NotNull Iterable<SentryEnvelopeItem> items) {
        this.header = Objects.requireNonNull(header, "SentryEnvelopeHeader is required.");
        this.items = Objects.requireNonNull(items, "SentryEnvelope items are required.");
    }

    public SentryEnvelope(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @NotNull Iterable<SentryEnvelopeItem> items) {
        this.header = new SentryEnvelopeHeader(eventId, sdkVersion);
        this.items = Objects.requireNonNull(items, "SentryEnvelope items are required.");
    }

    public SentryEnvelope(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @NotNull SentryEnvelopeItem item) {
        Objects.requireNonNull(item, "SentryEnvelopeItem is required.");
        this.header = new SentryEnvelopeHeader(eventId, sdkVersion);
        ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>(1);
        items.add(item);
        this.items = items;
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer, @NotNull Session session, @Nullable SdkVersion sdkVersion) throws IOException {
        Objects.requireNonNull(serializer, "Serializer is required.");
        Objects.requireNonNull(session, "session is required.");
        return new SentryEnvelope(null, sdkVersion, SentryEnvelopeItem.fromSession(serializer, session));
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer, @NotNull SentryBaseEvent event, @Nullable SdkVersion sdkVersion) throws IOException {
        Objects.requireNonNull(serializer, "Serializer is required.");
        Objects.requireNonNull(event, "item is required.");
        return new SentryEnvelope(event.getEventId(), sdkVersion, SentryEnvelopeItem.fromEvent(serializer, event));
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer, @NotNull ProfilingTraceData profilingTraceData, long maxTraceFileSize, @Nullable SdkVersion sdkVersion) throws SentryEnvelopeException {
        Objects.requireNonNull(serializer, "Serializer is required.");
        Objects.requireNonNull(profilingTraceData, "Profiling trace data is required.");
        return new SentryEnvelope(new SentryId(profilingTraceData.getProfileId()), sdkVersion, SentryEnvelopeItem.fromProfilingTrace(profilingTraceData, maxTraceFileSize, serializer));
    }
}

