/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import me.playbosswar.com.commandtimer.sentry.BaggageHeader;
import me.playbosswar.com.commandtimer.sentry.IHub;
import me.playbosswar.com.commandtimer.sentry.ISpan;
import me.playbosswar.com.commandtimer.sentry.Instrumenter;
import me.playbosswar.com.commandtimer.sentry.MeasurementUnit;
import me.playbosswar.com.commandtimer.sentry.NoOpSpan;
import me.playbosswar.com.commandtimer.sentry.SentryDate;
import me.playbosswar.com.commandtimer.sentry.SentryTraceHeader;
import me.playbosswar.com.commandtimer.sentry.SentryTracer;
import me.playbosswar.com.commandtimer.sentry.SpanContext;
import me.playbosswar.com.commandtimer.sentry.SpanFinishedCallback;
import me.playbosswar.com.commandtimer.sentry.SpanId;
import me.playbosswar.com.commandtimer.sentry.SpanOptions;
import me.playbosswar.com.commandtimer.sentry.SpanStatus;
import me.playbosswar.com.commandtimer.sentry.TraceContext;
import me.playbosswar.com.commandtimer.sentry.TracesSamplingDecision;
import me.playbosswar.com.commandtimer.sentry.TransactionContext;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryId;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Span
implements ISpan {
    @NotNull
    private SentryDate startTimestamp;
    @Nullable
    private SentryDate timestamp;
    @NotNull
    private final SpanContext context;
    @NotNull
    private final SentryTracer transaction;
    @Nullable
    private Throwable throwable;
    @NotNull
    private final IHub hub;
    @NotNull
    private final AtomicBoolean finished = new AtomicBoolean(false);
    @NotNull
    private final SpanOptions options;
    @Nullable
    private SpanFinishedCallback spanFinishedCallback;
    @NotNull
    private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();

    Span(@NotNull SentryId traceId, @Nullable SpanId parentSpanId, @NotNull SentryTracer transaction, @NotNull String operation, @NotNull IHub hub) {
        this(traceId, parentSpanId, transaction, operation, hub, null, new SpanOptions(), null);
    }

    Span(@NotNull SentryId traceId, @Nullable SpanId parentSpanId, @NotNull SentryTracer transaction, @NotNull String operation, @NotNull IHub hub, @Nullable SentryDate startTimestamp, @NotNull SpanOptions options, @Nullable SpanFinishedCallback spanFinishedCallback) {
        this.context = new SpanContext(traceId, new SpanId(), operation, parentSpanId, transaction.getSamplingDecision());
        this.transaction = Objects.requireNonNull(transaction, "transaction is required");
        this.hub = Objects.requireNonNull(hub, "hub is required");
        this.options = options;
        this.spanFinishedCallback = spanFinishedCallback;
        this.startTimestamp = startTimestamp != null ? startTimestamp : hub.getOptions().getDateProvider().now();
    }

    public Span(@NotNull TransactionContext context, @NotNull SentryTracer sentryTracer, @NotNull IHub hub, @Nullable SentryDate startTimestamp, @NotNull SpanOptions options) {
        this.context = Objects.requireNonNull(context, "context is required");
        this.transaction = Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.hub = Objects.requireNonNull(hub, "hub is required");
        this.spanFinishedCallback = null;
        this.startTimestamp = startTimestamp != null ? startTimestamp : hub.getOptions().getDateProvider().now();
        this.options = options;
    }

    @Override
    @NotNull
    public SentryDate getStartDate() {
        return this.startTimestamp;
    }

    @Override
    @Nullable
    public SentryDate getFinishDate() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        if (this.finished.get()) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description, timestamp, instrumenter, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        if (this.finished.get()) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @NotNull SpanOptions spanOptions) {
        if (this.finished.get()) {
            return NoOpSpan.getInstance();
        }
        return this.transaction.startChild(this.context.getSpanId(), operation, description, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter) {
        return this.startChild(operation, description, timestamp, instrumenter, new SpanOptions());
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(this.context.getTraceId(), this.context.getSpanId(), this.context.getSampled());
    }

    @Override
    @Nullable
    public TraceContext traceContext() {
        return this.transaction.traceContext();
    }

    @Override
    @Nullable
    public BaggageHeader toBaggageHeader(@Nullable List<String> thirdPartyBaggageHeaders) {
        return this.transaction.toBaggageHeader(thirdPartyBaggageHeaders);
    }

    @Override
    public void finish() {
        this.finish(this.context.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        this.finish(status, this.hub.getOptions().getDateProvider().now());
    }

    @Override
    public void finish(@Nullable SpanStatus status, @Nullable SentryDate timestamp) {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.context.setStatus(status);
        SentryDate sentryDate = this.timestamp = timestamp == null ? this.hub.getOptions().getDateProvider().now() : timestamp;
        if (this.options.isTrimStart() || this.options.isTrimEnd()) {
            @Nullable SentryDate minChildStart = null;
            SentryDate maxChildEnd = null;
            @NotNull List<Span> children = this.transaction.getRoot().getSpanId().equals(this.getSpanId()) ? this.transaction.getChildren() : this.getDirectChildren();
            for (Span child : children) {
                if (minChildStart == null || child.getStartDate().isBefore(minChildStart)) {
                    minChildStart = child.getStartDate();
                }
                if (maxChildEnd != null && (child.getFinishDate() == null || !child.getFinishDate().isAfter(maxChildEnd))) continue;
                maxChildEnd = child.getFinishDate();
            }
            if (this.options.isTrimStart() && minChildStart != null && this.startTimestamp.isBefore(minChildStart)) {
                this.updateStartDate(minChildStart);
            }
            if (this.options.isTrimEnd() && maxChildEnd != null && (this.timestamp == null || this.timestamp.isAfter(maxChildEnd))) {
                this.updateEndDate(maxChildEnd);
            }
        }
        if (this.throwable != null) {
            this.hub.setSpanContext(this.throwable, this, this.transaction.getName());
        }
        if (this.spanFinishedCallback != null) {
            this.spanFinishedCallback.execute(this);
        }
    }

    @Override
    public void setOperation(@NotNull String operation) {
        if (this.finished.get()) {
            return;
        }
        this.context.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.context.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        if (this.finished.get()) {
            return;
        }
        this.context.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.context.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        if (this.finished.get()) {
            return;
        }
        this.context.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.context.getStatus();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        if (this.finished.get()) {
            return;
        }
        this.context.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.context.getTags().get(key);
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Boolean isSampled() {
        return this.context.getSampled();
    }

    @Nullable
    public Boolean isProfileSampled() {
        return this.context.getProfileSampled();
    }

    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.context.getSamplingDecision();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        if (this.finished.get()) {
            return;
        }
        this.throwable = throwable;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.context.getTraceId();
    }

    @NotNull
    public SpanId getSpanId() {
        return this.context.getSpanId();
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.context.getParentSpanId();
    }

    public Map<String, String> getTags() {
        return this.context.getTags();
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
        if (this.finished.get()) {
            return;
        }
        this.data.put(key, value);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return this.data.get(key);
    }

    @Override
    public void setMeasurement(@NotNull String name, @NotNull Number value) {
        this.transaction.setMeasurement(name, value);
    }

    @Override
    public void setMeasurement(@NotNull String name, @NotNull Number value, @NotNull MeasurementUnit unit) {
        this.transaction.setMeasurement(name, value, unit);
    }

    @Override
    public boolean updateEndDate(@NotNull SentryDate date) {
        if (this.timestamp != null) {
            this.timestamp = date;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    void setSpanFinishedCallback(@Nullable SpanFinishedCallback callback) {
        this.spanFinishedCallback = callback;
    }

    private void updateStartDate(@NotNull SentryDate date) {
        this.startTimestamp = date;
    }

    @NotNull
    SpanOptions getOptions() {
        return this.options;
    }

    @NotNull
    private List<Span> getDirectChildren() {
        ArrayList<Span> children = new ArrayList<Span>();
        for (Span span : this.transaction.getSpans()) {
            if (span.getParentSpanId() == null || !span.getParentSpanId().equals(this.getSpanId())) continue;
            children.add(span);
        }
        return children;
    }
}

