/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.hints;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.hints.DiskFlushNotification;
import me.playbosswar.com.commandtimer.sentry.hints.Flushable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class BlockingFlushHint
implements DiskFlushNotification,
Flushable {
    private final CountDownLatch latch;
    private final long flushTimeoutMillis;
    @NotNull
    private final ILogger logger;

    public BlockingFlushHint(long flushTimeoutMillis, @NotNull ILogger logger) {
        this.flushTimeoutMillis = flushTimeoutMillis;
        this.latch = new CountDownLatch(1);
        this.logger = logger;
    }

    @Override
    public boolean waitFlush() {
        try {
            return this.latch.await(this.flushTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.log(SentryLevel.ERROR, "Exception while awaiting for flush in BlockingFlushHint", e);
            return false;
        }
    }

    @Override
    public void markFlushed() {
        this.latch.countDown();
    }
}

