/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.protocol;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.JsonDeserializer;
import me.playbosswar.com.commandtimer.sentry.JsonObjectReader;
import me.playbosswar.com.commandtimer.sentry.JsonSerializable;
import me.playbosswar.com.commandtimer.sentry.JsonUnknown;
import me.playbosswar.com.commandtimer.sentry.ObjectWriter;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.protocol.Geo;
import me.playbosswar.com.commandtimer.sentry.util.CollectionUtils;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import me.playbosswar.com.commandtimer.sentry.vendor.gson.stream.JsonToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class User
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String email;
    @Nullable
    private String id;
    @Nullable
    private String username;
    @Nullable
    private String segment;
    @Nullable
    private String ipAddress;
    @Nullable
    private String name;
    @Nullable
    private Geo geo;
    private @Nullable Map<String, @NotNull String> data;
    private @Nullable Map<String, @NotNull Object> unknown;

    public User() {
    }

    public User(@NotNull User user) {
        this.email = user.email;
        this.username = user.username;
        this.id = user.id;
        this.ipAddress = user.ipAddress;
        this.segment = user.segment;
        this.name = user.name;
        this.geo = user.geo;
        this.data = CollectionUtils.newConcurrentHashMap(user.data);
        this.unknown = CollectionUtils.newConcurrentHashMap(user.unknown);
    }

    public static User fromMap(@NotNull Map<String, Object> map, @NotNull SentryOptions options) {
        User user = new User();
        ConcurrentHashMap<String, Object> unknown = null;
        block22: for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            switch (entry.getKey()) {
                case "email": {
                    user.email = value instanceof String ? (String)value : null;
                    continue block22;
                }
                case "id": {
                    user.id = value instanceof String ? (String)value : null;
                    continue block22;
                }
                case "username": {
                    user.username = value instanceof String ? (String)value : null;
                    continue block22;
                }
                case "segment": {
                    user.segment = value instanceof String ? (String)value : null;
                    continue block22;
                }
                case "ip_address": {
                    user.ipAddress = value instanceof String ? (String)value : null;
                    continue block22;
                }
                case "name": {
                    user.name = value instanceof String ? (String)value : null;
                    continue block22;
                }
                case "geo": {
                    Map geo = value instanceof Map ? (Map)value : null;
                    if (geo == null) continue block22;
                    ConcurrentHashMap<String, Object> geoData = new ConcurrentHashMap<String, Object>();
                    for (Map.Entry geoEntry : geo.entrySet()) {
                        if (geoEntry.getKey() instanceof String && geoEntry.getValue() != null) {
                            geoData.put((String)geoEntry.getKey(), geoEntry.getValue());
                            continue;
                        }
                        options.getLogger().log(SentryLevel.WARNING, "Invalid key type in gep map.", new Object[0]);
                    }
                    user.geo = Geo.fromMap(geoData);
                    continue block22;
                }
                case "data": {
                    Map.Entry geoEntry;
                    Map data = value instanceof Map ? (Map)value : null;
                    if (data == null) continue block22;
                    ConcurrentHashMap<String, String> userData = new ConcurrentHashMap<String, String>();
                    geoEntry = data.entrySet().iterator();
                    while (geoEntry.hasNext()) {
                        Map.Entry dataEntry = geoEntry.next();
                        if (dataEntry.getKey() instanceof String && dataEntry.getValue() != null) {
                            userData.put((String)dataEntry.getKey(), dataEntry.getValue().toString());
                            continue;
                        }
                        options.getLogger().log(SentryLevel.WARNING, "Invalid key or null value in data map.", new Object[0]);
                    }
                    user.data = userData;
                    continue block22;
                }
                case "other": {
                    Map other = value instanceof Map ? (Map)value : null;
                    if (other == null || user.data != null && !user.data.isEmpty()) continue block22;
                    ConcurrentHashMap<String, String> userData = new ConcurrentHashMap<String, String>();
                    for (Map.Entry otherEntry : other.entrySet()) {
                        if (otherEntry.getKey() instanceof String && otherEntry.getValue() != null) {
                            userData.put((String)otherEntry.getKey(), otherEntry.getValue().toString());
                            continue;
                        }
                        options.getLogger().log(SentryLevel.WARNING, "Invalid key or null value in other map.", new Object[0]);
                    }
                    user.data = userData;
                    continue block22;
                }
            }
            if (unknown == null) {
                unknown = new ConcurrentHashMap<String, Object>();
            }
            unknown.put(entry.getKey(), entry.getValue());
        }
        user.unknown = unknown;
        return user;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    public String getSegment() {
        return this.segment;
    }

    public void setSegment(@Nullable String segment) {
        this.segment = segment;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(@Nullable String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Deprecated
    public @Nullable Map<String, @NotNull String> getOthers() {
        return this.getData();
    }

    @Deprecated
    public void setOthers(@Nullable Map<String, @NotNull String> other) {
        this.setData(other);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(@Nullable Geo geo) {
        this.geo = geo;
    }

    public @Nullable Map<String, @NotNull String> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, @NotNull String> data) {
        this.data = CollectionUtils.newConcurrentHashMap(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.email, user.email) && Objects.equals(this.id, user.id) && Objects.equals(this.username, user.username) && Objects.equals(this.segment, user.segment) && Objects.equals(this.ipAddress, user.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.id, this.username, this.segment, this.ipAddress);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.email != null) {
            writer.name("email").value(this.email);
        }
        if (this.id != null) {
            writer.name("id").value(this.id);
        }
        if (this.username != null) {
            writer.name("username").value(this.username);
        }
        if (this.segment != null) {
            writer.name("segment").value(this.segment);
        }
        if (this.ipAddress != null) {
            writer.name("ip_address").value(this.ipAddress);
        }
        if (this.name != null) {
            writer.name("name").value(this.name);
        }
        if (this.geo != null) {
            writer.name("geo");
            this.geo.serialize(writer, logger);
        }
        if (this.data != null) {
            writer.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String EMAIL = "email";
        public static final String ID = "id";
        public static final String USERNAME = "username";
        public static final String SEGMENT = "segment";
        public static final String IP_ADDRESS = "ip_address";
        public static final String NAME = "name";
        public static final String GEO = "geo";
        public static final String OTHER = "other";
        public static final String DATA = "data";
    }

    public static final class Deserializer
    implements JsonDeserializer<User> {
        @Override
        @NotNull
        public User deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            User user = new User();
            ConcurrentHashMap<String, Object> unknown = null;
            block22: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "email": {
                        user.email = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "id": {
                        user.id = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "username": {
                        user.username = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "segment": {
                        user.segment = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "ip_address": {
                        user.ipAddress = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "name": {
                        user.name = reader.nextStringOrNull();
                        continue block22;
                    }
                    case "geo": {
                        user.geo = new Geo.Deserializer().deserialize(reader, logger);
                        continue block22;
                    }
                    case "data": {
                        user.data = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block22;
                    }
                    case "other": {
                        if (user.data != null && !user.data.isEmpty()) continue block22;
                        user.data = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block22;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            user.setUnknown(unknown);
            reader.endObject();
            return user;
        }
    }
}

