/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.conditions;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.util.ArrayList;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.ConditionExtension;
import me.playbosswar.com.api.ConditionRule;
import me.playbosswar.com.api.ConditionRules;
import me.playbosswar.com.api.NeededValue;
import me.playbosswar.com.conditionsengine.ConditionParamField;
import me.playbosswar.com.conditionsengine.validations.SimpleCondition;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.MenuUtils;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SimpleConditionMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;
    private final SimpleCondition simpleCondition;
    private final Callback<?> onClose;
    private String selectedConditionGroup;
    private String ruleName;

    public SimpleConditionMenu(Task task, SimpleCondition simpleCondition, Callback<?> onClose) {
        this.task = task;
        this.simpleCondition = simpleCondition;
        this.onClose = onClose;
        this.selectedConditionGroup = simpleCondition.getConditionGroup();
        this.ruleName = simpleCondition.getRule();
        this.INVENTORY = SmartInventory.builder().id("simple-condition").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.SIMPLE_CONDITION_GUI_TITLE)).build();
    }

    private void changeSelectedConditionGroup(String newGroup) {
        String conditionGroup = this.simpleCondition.getConditionGroup();
        if (conditionGroup != null && conditionGroup.equals(newGroup)) {
            this.simpleCondition.setConditionGroup(null);
            this.simpleCondition.setRule(null);
            this.selectedConditionGroup = null;
            this.ruleName = null;
            return;
        }
        this.simpleCondition.setConditionGroup(newGroup);
        this.selectedConditionGroup = newGroup;
        this.task.storeInstance();
    }

    private void changeSelectedRule(String rule) {
        this.simpleCondition.setRule(rule);
        this.ruleName = rule;
        ConditionRule conditionRule = CommandTimerPlugin.getInstance().getConditionEngineManager().getRule(this.selectedConditionGroup, rule);
        if (conditionRule.getNeededValues() == null) {
            this.simpleCondition.setConditionParamFields(null);
            this.task.storeInstance();
            return;
        }
        ArrayList conditionParamFields = new ArrayList();
        ArrayList<NeededValue<?>> neededValues = conditionRule.getNeededValues();
        for (NeededValue<?> neededValue : neededValues) {
            conditionParamFields.add(new ConditionParamField(neededValue.getName(), neededValue.getDefaultValue()));
        }
        this.simpleCondition.setConditionParamFields(conditionParamFields);
        this.task.storeInstance();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        contents.fillRow(2, ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems(this.getActiveRules(player));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY, 14, 5, 3, 1);
        int i = 1;
        for (ClickableItem clickableItem : this.getAllConditionGroups(player)) {
            contents.set(1, i, clickableItem);
            ++i;
        }
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> this.onClose.execute(null)));
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }

    private ClickableItem[] getActiveRules(Player p) {
        ConditionExtension conditionExtension = CommandTimerPlugin.getInstance().getConditionEngineManager().getConditionExtension(this.selectedConditionGroup);
        if (conditionExtension == null) {
            return new ClickableItem[0];
        }
        ConditionRules rules = conditionExtension.getRules();
        ClickableItem[] items = new ClickableItem[rules.size()];
        ArrayList<ConditionRule> rulesList = new ArrayList<ConditionRule>();
        for (ConditionRule value : rules) {
            rulesList.add(value);
        }
        for (int i = 0; i < rulesList.size(); ++i) {
            ConditionRule rule = (ConditionRule)rulesList.get(i);
            ItemStack item = Items.generateItem("\u00a7b" + rule.getName(), XMaterial.COMPARATOR, new String[]{"", "\u00a77" + rule.getDescription()});
            if (this.ruleName != null && this.ruleName.equals(rule.getName())) {
                item.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 1);
                ItemMeta meta = item.getItemMeta();
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(meta);
            }
            items[i] = ClickableItem.of(item, e -> {
                if (e.getClick().equals((Object)ClickType.LEFT)) {
                    this.changeSelectedRule(rule.getName());
                    this.INVENTORY.open(p);
                }
            });
        }
        return items;
    }

    private ClickableItem[] getAllConditionGroups(Player p) {
        List<ConditionExtension> conditionExtensions = CommandTimerPlugin.getInstance().getConditionEngineManager().getConditionExtensions();
        ClickableItem[] items = new ClickableItem[conditionExtensions.size()];
        for (int i = 0; i < items.length; ++i) {
            ConditionExtension conditionExtension = conditionExtensions.get(i);
            String conditionGroupName = conditionExtension.getConditionGroupName();
            ItemStack item = MenuUtils.getExtensionItem(conditionExtension);
            if (this.selectedConditionGroup != null && this.selectedConditionGroup.equals(conditionGroupName)) {
                item.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 1);
                ItemMeta meta = item.getItemMeta();
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(meta);
            }
            items[i] = ClickableItem.of(item, e -> {
                if (e.getClick().equals((Object)ClickType.LEFT)) {
                    this.changeSelectedConditionGroup(conditionGroupName);
                    this.INVENTORY.open(p);
                }
            });
        }
        return items;
    }
}

